#!/usr/bin/perl

=pod

=encoding utf8

    $Id:$

=head1 NAME

    canvas_to_html5.pl

=head1 SYNOPSIS

    LOG_TEE=1 ./protected/one-shot/canvas_to_html5.pl --client-id 12345 --canvas-id 10 --base-path "http://asdf" --canvas-id 20 --base-path "http://ddd"

=head1 DESCRIPTION

    Для эксперимент протаскиваем html5 с видео игрой на поиск, в рамках ТГО кампании (нужна оплата по кликам).
    Для этого создаем ТГО кампанию в ней ГО по креативам, а потом по базе
    меняем у креатива тип, убираем moderate_info и добавляем yabs_info

    Подробностви в https://st.yandex-team.ru/BSDEV-67694

    Порядок canvas-id в параметрах должен совпадать с порядком base-path

    В обычном режиме скрипт следит чтобы состояние креатива в БД было
    соответствующим ожиадаемому (creative_type=canvas), для повторного
    обновления того же креатива, когда например нужно еще раз поменять basePath
    можно использовать опцию --ignore-errors

    проверить работу сприпта можно опцией --dry-run

=head1 METHODS

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '../..';

use ScriptHelper;
use Settings;


extract_script_params(
    'client-id=i' => \my $client_id,
    'creative-id=i' => \my @creative_ids,
    'base-path=s' => \my @base_paths,
    'ignore-errors' => \my $ignore_errors,
    'dry-run' => \my $dry_run,
);

$log->out('START');
$log->die("clientId are mandatory") unless $client_id;
$log->die("creativeIds are mandatory") unless @creative_ids;
$log->die("basePaths are mandatory") unless @base_paths;
$log->die("foreach creative_id should be a basePath") unless scalar(@base_paths) eq scalar(@creative_ids);


my $dbh = PPC(ClientID => $client_id);
my $current_creatives_by_id = get_hashes_hash_sql($dbh, ["select creative_id, moderate_info, creative_type, yabs_data from perf_creatives", where => {ClientID => $client_id, creative_id => \@creative_ids}]);

$log->out("current state in db: ", $current_creatives_by_id);

my $cr_to_bp;
for(my $i=0; $i<=$#creative_ids; $i++) {
    $cr_to_bp->{$creative_ids[$i]} = $base_paths[$i];
}

$log->out("provided basetPaths for creatives: ");
$log->out({ $_ => $cr_to_bp->{$_} }) foreach (sort keys %$cr_to_bp);

my $has_errors;
foreach my $creative_id (@creative_ids) {
    my @errors;
    my $prefix = "creative $creative_id:";
    if(my $current_creative = $current_creatives_by_id->{$creative_id}) {
        push @errors, "$prefix expected to have type canvas" unless $current_creative->{creative_type} eq 'canvas';
        push @errors, "$prefix expected to have null yabs_data" unless !defined $current_creative->{yabs_data};
        push @errors, "$prefix expected to have moderate_info" unless defined $current_creative->{moderate_info};
    } else {
        push @errors, "$prefix not found in db for client $client_id";
    }
    $has_errors = 1 if @errors;
    $log->out($_) foreach @errors;
}

if ($has_errors && !$ignore_errors) {
    $log->die("exiting due to found errors");
}

$log->out("updating creatives: " . join(', ', sort @creative_ids) .  " with data");
foreach my $creative_id (sort @creative_ids) {
    next unless exists $current_creatives_by_id->{$creative_id};
    my $where = { clientid => $client_id, creative_id => $creative_id };
    unless($ignore_errors) {
        $where->{creative_type} = 'canvas';
        $where->{yabs_data__is_null} = 1;
    }
    my $data = {
        creative_type => "html5_creative",
        moderate_info => undef,
        yabs_data => qq~{"html5": true, "basePath": "$cr_to_bp->{$creative_id}"}~,
    };
    $log->out({$creative_id => $data});
    if (!$dry_run) {
        my $res = do_update_table($dbh, 'perf_creatives', $data, where => $where);
        $log->out("..update failed") unless $res;
    }
}

$log->out('FINISH');

