#!/usr/bin/perl

#Безусловное изменение типа автотаргетинга с relevance_match_search на relevance_match 
use my_inc '../..';

use Direct::Modern;
use Settings;
use ScriptHelper;
use ShardingTools;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;
use Yandex::Retry qw/relaxed/;

my $SLEEP_COEF = 1;
my $CHUNK_SIZE = 500;
my $SHARD;

extract_script_params(
    'sleep-coef=i' => \$SLEEP_COEF,
    'chunk-size=i' => \$CHUNK_SIZE,
    'shard=i' => \$SHARD,
);

$log->out(sprintf('START: chunk size %s, rest coefficient %s', $CHUNK_SIZE, $SLEEP_COEF));
for my $shard ( $SHARD // ppc_shards() ) {
    my $guard = $log->msg_prefix_guard("[shard_$shard]");

    $log->out('BEGIN');
    my $bid_ids =  get_one_column_sql(PPC(shard => $shard),[
            'SELECT bid_id FROM bids_base',
            WHERE => {bid_type => 'relevance_match_search'},
    ]);
    $log->out(sprintf('select done, found %s records', scalar @$bid_ids));

    foreach my $chunk (chunks($bid_ids, $CHUNK_SIZE)) {
        relaxed times => $SLEEP_COEF, sub {
            return unless @$chunk;
            my $updated = do_update_table( PPC(shard => $shard), 'bids_base', { bid_type => 'relevance_match'}, where => {bid_id => $chunk, bid_type => 'relevance_match_search'} );
            $log->out(sprintf('Updated %s records, bid_ids: [%s]', $updated, join(', ', @$chunk)));
        };
    }
    $log->out('SHARD COMPLETED');
}
$log->out('FINISH');
