#!/usr/bin/perl


use Direct::Modern;
use my_inc '../..';

use Yandex::DBTools;
use Direct::Campaigns;
use JSON;

use ShardingTools;
use ScriptHelper (log_warn => 1);
use Settings;


my $CHUNK_SIZE = 2000;

extract_script_params(
    'cid=i' => \my @only_cids,
    'shard-id=i' => \my @shards,
);

@shards = ppc_shards() if !@shards;


$log->out('START');

SHARD:
for my $shard (@shards) {
    $log->out("processing shard #$shard");
    my $min_cid = 0;
    while (1) {
        my $db_camps = get_hashes_hash_sql(PPC(shard => $shard), [
                "SELECT cid, platform, strategy_name, strategy_data
                FROM campaigns c",
                WHERE => {
                    type => [qw/ text mobile_content dynamic geo performance mcbanner /],
                    cid__gt => $min_cid,
                    (@only_cids ? (cid => \@only_cids) : ()),
                },
                'ORDER BY cid',
                LIMIT => $CHUNK_SIZE,
            ]);
        last if !%$db_camps;

        my @cids = sort {$a <=> $b} keys %$db_camps;
        $min_cid = $cids[-1];

        $log->out(sprintf "shard #$shard: going to process %d campaigns ($cids[0] .. $cids[-1])", scalar @cids);

        my $campaigns = Direct::Campaigns->get(\@cids);
        for my $camp (@{$campaigns->items}) {
            my $cid = $camp->id;
            my $db_camp = $db_camps->{$cid};

            my $expected_platform = $camp->_platform;
            if ($expected_platform ne $db_camp->{platform}) {
                $log->out("!! cid=$cid: platform differs $expected_platform <--> $db_camp->{platform}");
            }

            my $expected_strategy_name = $camp->strategy_name;
            if ($expected_strategy_name ne $db_camp->{strategy_name}) {
                $log->out("!! cid=$cid: strategy_name differs $expected_strategy_name <--> $db_camp->{strategy_name}");
            }

            my $expected_data = $camp->_strategy_data;
            my $got_data = to_json(from_json($db_camp->{strategy_data}), {canonical => 1});
            if ($expected_data ne $got_data) {
                $log->out("!! cid=$cid: strategy_data differs $expected_data <--> $got_data");
            }
        }

#        use YAML; die Dump \%update;
    }
}

$log->out('FINISH');

