#!/usr/bin/perl

=head1 NAME

    close_balance_for_ya_agency_orders.pl - отправка в баланс откруток для закрытых в директе заказов платного сервиса

=head1 DESCRIPTION

    Из таблицы заказов платного сервиса выбираются все со статусом 'Completed'
    и для них в баланс отправляется финализирующий Balance.UpdateCampaigns
    
    Параметры:
    --order_id — обработать только выбранный заказ

=cut

use my_inc '../..';

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;
use Direct::YaAgency;
use Settings;
use ScriptHelper;

my $ORDER_ID;
extract_script_params(
    'order_id=i' => \$ORDER_ID,
);

sub main {
    $log->out('START');

    my $completed_orders;
    $completed_orders = $ORDER_ID || get_one_column_sql(PPC(shard => 'all'),
        ['SELECT yaOrderId FROM yandex_agency_orders',
            WHERE => {yaOrderStatus => 'Completed'}
        ]
    );
   
    $completed_orders = [$completed_orders] unless ref $completed_orders;

    for my $chunk ( chunks( $completed_orders, 50) ) {
        my $result = Direct::YaAgency::_close_balance($chunk);
        while (my ($order_id, $ok) = each %$result) {
            $log->out("OrderID => $order_id, ok => $ok");
        }
    }
    $log->out('FINISH');
}

main();
