#!/usr/bin/perl

use Direct::Modern;

use Yandex::Balance;
use Yandex::DBTools;
use Yandex::ListUtils;

use my_inc '../..';

use Client;
use ScriptHelper;
use Settings;
use ShardingTools;

my $DATE_FROM = "2017-01-16";
my $DATE_TO = "2017-01-28";
my $RESEND => 0;

my $SID = $Settings::SERVICEID{direct};

extract_script_params(
    'date_from=s' => \$DATE_FROM,
    'date_to=s' => \$DATE_TO,
    'resend!' => \$RESEND,
);

$log->out('START');

$log->out("working for users, created between $DATE_FROM AND $DATE_TO");

for my $shard (ppc_shards()) {
    my $pref_guard = $log->msg_prefix_guard("[shard #$shard]");

    my %to_fix;
    $log->out("fetch clients from DB");

    my $clients = get_hashes_hash_sql(PPC(shard => $shard), 'SELECT DISTINCT cl.ClientID, cl.country_region_id, cl.work_currency FROM users u
            JOIN clients cl ON cl.ClientID = u.ClientID
            WHERE cl.country_region_id != 0
            AND IFNULL(cl.work_currency, "YND_FIXED") != "YND_FIXED"
            AND u.createtime BETWEEN UNIX_TIMESTAMP(?) AND UNIX_TIMESTAMP(?)'
            , $DATE_FROM, $DATE_TO);

    for my $chunk (chunks([keys %$clients], 200)) {
        $log->out("fetch clients chunk from BALANCE");

        for my $entry ( @{ balance_get_clients($chunk) } ) {
            my $country_id = $entry->{REGION_ID};
            my $client_id = $entry->{CLIENT_ID};
            my $currency = $entry->{SERVICE_DATA}->{$SID}->{CURRENCY};

            my $direct_entry = $clients->{$client_id};

            my $action;
            if (!$country_id && $entry->{AGENCY_ID} != 0) {
                $action = "SKIP";
            } elsif (!$currency || $currency ne $direct_entry->{work_currency} || !$country_id || $country_id != $direct_entry->{country_region_id}) {
                # extra check
                if (!%{ $entry->{SERVICE_DATA}->{$SID} }) {
                    $to_fix{$client_id} = undef;
                    $action = "TO_FIX";
                } else {
                    $action = "SKIP";
                }
            } else {
                $action = "OK";
            }
            $log->out({$action => $client_id, direct => $direct_entry, balance => $entry})
        }
    }

    $log->out("Got " . scalar(keys(%to_fix)) . " clients to resend to BALANCE");

    if ($RESEND) {
        for my $client_id (keys %to_fix) {
            my $direct_entry = $clients->{$client_id};

            my %balance_upd;
            $balance_upd{CURRENCY} = $direct_entry->{work_currency};
            $balance_upd{MIGRATE_TO_CURRENCY} = Client::get_client_migrate_to_currency($client_id);
            $balance_upd{REGION_ID} = $direct_entry->{country_region_id};

            $log->out({UPDATE => $client_id, data => \%balance_upd});
            if (my $is_error = update_client_id(1, $client_id, \%balance_upd)) {
                $log->out("update ClientID $client_id FAILED");
            } else {
                $log->out("ClientID $client_id updated in balance");
            }
        }
    } else {
        $log->out("skip resend");
    }
}

$log->out('FINISH');
