#!/usr/bin/perl

use my_inc "../..";


=head1 DESCRIPTION

Скрипт для миграции.
Преобразовует phraseIdHistory старого формата в новый формат, рассчитанный на группы баннеров, и картинки.

=cut

use warnings;
use strict;

use List::MoreUtils qw/uniq/;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use Tools;
use BS::History;

$Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

run() unless caller();

sub run
{
    $log->out("START");

    my $opt = parse_options();

    my $max_cid = get_one_field_sql(PPC, "select max(cid) from campaigns");
    $log->out("start from $opt->{start}");

    my $chunk_size = 1_000;
    my $chunks = int($max_cid/$chunk_size) + 1;
    $log->out("max(cid): $max_cid, chunk_size: $chunk_size, chunks: $chunks");

    # bids_phraseid_history
    $log->out("from bids_phraseid_history to bids_phraseid_history - start");
    for my $n (0 .. $chunks - 1){
        my $start = $chunk_size * $n;
        #print "$start\n";
        my $end = $start + $chunk_size - 1;
        $log->out("processing cid $start .. $end");
        foreach my $tbl (qw/bids bids_arc/) {
            my $bids_phraseid_history_old = get_all_sql(PPC, 
                "select o.cid, b.bid, o.id, phraseIdHistory from 
                        bids_phraseid_history o
                   join $tbl bi ON bi.cid = o.cid and bi.id = o.id
                   join banners b using (bid)
                where phraseIdHistory != '' and o.update_time >= ? and o.cid between ? and ?", 
                $opt->{start}, $start, $end
            );
            fill_order_id_cache(\@$bids_phraseid_history_old);
            my $bids_phraseid_history = [];
            for my $o (@$bids_phraseid_history_old){
                my $phraseIdHistory = phraseIdHistory_old_to_phraseIdHistory($o->{cid}, $o->{bid}, $o->{phraseIdHistory});
                if ($phraseIdHistory){
                    push @$bids_phraseid_history, [$o->{cid}, $o->{id}, $phraseIdHistory];
                }
            }
            my $dbh = get_dbh(PPC);
            while (my @chunk = splice(@$bids_phraseid_history, 0, 1000)) {
                do_sql(PPC, [q/INSERT INTO bids_phraseid_history (cid, id, phraseIdHistory) VALUES /, join(',', map {my @row = @$_; '('. join(',', map { sql_quote($_) } @row) .')'} @chunk),
                             q/ON DUPLICATE KEY UPDATE phraseIdHistory = VALUES(phraseIdHistory)/ ]);
            }
        }
        clear_order_id_cache();
    }
    $log->out("from bids_phraseid_history to bids_phraseid_history - done");

    # mediaplan_bids
    $log->out("from mediaplan_bids.bsIdHistory to mediaplan_bids.phraseIdHistory - start");
    for my $n (0 .. $chunks - 1){
        my $start = $chunk_size * $n;
        my $end = $start + $chunk_size - 1;
        $log->out("processing cid $start .. $end");
        my $bids_phraseid_history_old = get_all_sql(PPC, 
            "select bi.cid, bi.id, b.source_bid as bid, bi.phraseIdHistory from 
                mediaplan_bids bi
            join mediaplan_banners b using (mbid) 
            where IFNULL(phraseIdHistory, '') <> '' and b.cid between ? and ?", 
            $start, $end
        ) || [];
        next if scalar @$bids_phraseid_history_old == 0;
        fill_order_id_cache(\@$bids_phraseid_history_old);
        for my $o (@$bids_phraseid_history_old){
            $o->{phraseIdHistory_new} = phraseIdHistory_old_to_phraseIdHistory($o->{cid}, $o->{bid} || 0, $o->{phraseIdHistory});
        }
        my $f = 0;
        while (my @chunk = splice(@$bids_phraseid_history_old, 0, 1000)) {
            do_update_table(
                PPC,
                'mediaplan_bids',
                {phraseIdHistory__dont_quote => sql_case(PPC, 'phraseIdHistory', {map {$_->{phraseIdHistory} => $_->{phraseIdHistory_new}} @chunk}, default__dont_quote => '""')},   
                where => {id => [map {$_->{id}} @chunk]}
            );
        }
        clear_order_id_cache();
    }

    $log->out("from mediaplan_bids.phraseIdHistory to mediaplan_bids.phraseIdHistory - done");

    # mediaplan_banners_original
    $log->out("from mediaplan_banners_original.data_json.phraseIdHistory to mediaplan_banners_original.data_json.phraseIdHistory - start");

    for my $n (0 .. $chunks - 1){
        my $start = $chunk_size * $n;
        my $end = $start + $chunk_size - 1;
        $log->out("processing cid $start .. $end");
        my $banners_original = get_all_sql(PPC, 
            "select cid, mbid, data_json from 
            mediaplan_banners_original
            where data_json is not null and cid between ? and ?", 
            $start, $end
        ) || [];
        next if scalar @$banners_original == 0;
        my $bids_phraseid_history_old = [];
        for my $ba (@$banners_original){
            $ba->{data_json} = decode_json_and_uncompress( $ba->{data_json});
            push @$bids_phraseid_history_old, map { $_->{phraseIdHistory} ? {phraseIdHistory => $_->{phraseIdHistory},
                                                                             bid => $ba->{data_json}->{source_bid}} : () } @{$ba->{data_json}->{Phrases} || []};
        }

        fill_order_id_cache(\@$bids_phraseid_history_old);
        for my $ba (@$banners_original){
            for my $ph ( @{$ba->{data_json}->{Phrases} || []} ){
                $ph->{phraseIdHistory} = phraseIdHistory_old_to_phraseIdHistory(0, $ba->{data_json}->{source_bid}, $ph->{phraseIdHistory});
            }
            $ba->{data_json} = encode_json_and_compress($ba->{data_json});
            do_update_table(PPC, "mediaplan_banners_original", 
                { data_json => $ba->{data_json} }, 
                where => { cid => $ba->{cid}, mbid => $ba->{mbid}}
            );
        }
        clear_order_id_cache();
    }

    $log->out("from mediaplan_banners_original.data_json.phraseIdHistory to mediaplan_banners_original.data_json.phraseIdHistory - done");

    $log->out("FINISH");
}


sub phraseIdHistory_old_to_phraseIdHistory
{
    my ($cid, $bid, $phraseIdHistory_old) = @_;

    return '' if ! defined $phraseIdHistory_old || $phraseIdHistory_old eq '';
    return $phraseIdHistory_old if $phraseIdHistory_old =~ /(^|;)[OP]/;

    my %history = (OrderID => undef, GroupID => undef, phrases => [], banners => {});
    my @old_ids = split ",", $phraseIdHistory_old;
    for my $i (0 .. scalar(@old_ids) - 1){
        if ( $i % 2 == 1 ){
            push @{$history{phrases}}, $old_ids[$i] unless grep { $_ == $old_ids[$i] } @{$history{phrases}};
        } else {
            if ($old_ids[$i] =~ /^B(\d+)$/) {
                push @{$history{banners}->{$bid}}, $1 unless exists $history{banners}->{$bid} && @{$history{banners}->{$bid}} && grep { $_ == $1 } @{$history{banners}->{$bid}};
            }
        }
    }

    $history{OrderID} = get_order_id($history{banners}->{$bid}->[0]);
    $history{GroupID} = _get_pid($history{banners}->{$bid}->[-1]);

    return BS::History::serialize_bids_history(\%history);
}


{
    my %ORDER_ID;

sub get_order_id
{
    my ($BannerID) = @_;
    my $OrderID = $ORDER_ID{$BannerID} ? $ORDER_ID{$BannerID}->{OrderID} : undef;
    $log->out("no OrderID for BannerID = $BannerID") unless $OrderID;
    $OrderID = '' if ! defined $OrderID;
    return $OrderID;
}

sub _get_pid
{
    my ($BannerID) = @_;
    my $pid = $ORDER_ID{$BannerID} ? $ORDER_ID{$BannerID}->{pid} : undef;
    $log->out("no pid for BannerID = $BannerID") unless $pid;
    $pid = '' if ! defined $pid;
    return $pid;
}

sub fill_order_id_cache
{
    my ($hists) = @_;
    my @BannerIDs = uniq grep { $_ } map { /^B(\d+)$/ ? $1 : () } map { split ',', $_->{phraseIdHistory} } @$hists;
    while (my @chunk = splice(@BannerIDs, 0, 1000)) {
        my $new_order_ids = get_hashes_hash_sql(PPC, ["select b.BannerID, c.OrderID, b.pid FROM banners b join campaigns c ON c.cid = b.cid AND c.OrderID <> 0",
                                                     where => {'b.BannerID' => \@chunk}]);
        %ORDER_ID = (%ORDER_ID, %$new_order_ids);
    }

    return '';
}

sub clear_order_id_cache
{
    %ORDER_ID = ();
}


}


sub parse_options
{
    my %O = (
    );

    extract_script_params(
        "s|start=s"           => \$O{start},
    );

    die unless $O{start};

    return \%O;
}


