#!/usr/bin/perl

use my_inc '../..';

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'порядка 1-5 минут с дефолтным --sleep-coef 0.1',
  comment => 'Подтягиваем скриншоты для смарт-банеров',
}

=cut

use constant SELECT_CHUNK_SIZE => 100;

use Direct::Modern;

use Yandex::DBTools;
use Yandex::Retry;

use Settings;
use ScriptHelper;
use ShardingTools;

use Direct::Creatives qw /sync_creative_screenshots/;

$log->out('START');

my $SLEEP_COEF = 0.1;
my $LIMIT = SELECT_CHUNK_SIZE;
extract_script_params(
    'sleep-coef=s' => \$SLEEP_COEF,
    'int-api-quantity=s' => \$LIMIT,
);

for my $shard (ppc_shards()) {
    $log->msg_prefix("[shard$shard]");

    my $last_creative_id = 0;
    my $total = 0;
    my $creatives;
    do {
        $creatives = get_all_sql(PPC(shard => $shard), 'SELECT creative_id, ClientID as client_id FROM perf_creatives WHERE creative_id > ? ORDER BY creative_id LIMIT ?', $last_creative_id, $LIMIT);
        relaxed times => $SLEEP_COEF, sub {
           $log->out(sprintf 'Syncing %s .. %s ', $total, $total + scalar @$creatives || 1 - 1 );

           my ( $processed, $skipped ) = sync_creative_screenshots($creatives);
           $log->out('Skipped: '. join ', ', map { $_->id } @$skipped) if $skipped && @$skipped;
        };

        my $last_creative = $creatives->[-1] || {};
        $last_creative_id = $last_creative->{creative_id};
        $total += @$creatives;

    } while @$creatives == $LIMIT;
}

$log->msg_prefix('');

$log->out('FINISH');
