#!/usr/bin/perl

use Direct::Modern;
use my_inc '../..';

use Settings;
use ScriptHelper;
use ShardingTools qw/ppc_shards/;
use PrimitivesIds qw/get_key2clientid/;
use BS::ResyncQueue qw/bs_resync/;

use Yandex::DBTools;
use Yandex::DateTime qw/now/;
use Yandex::Retry qw/relaxed_guard/;
use JSON;
use List::MoreUtils qw/any/;
use DateTime::Format::MySQL qw//;
use YAML::Syck qw//;
$YAML::Syck::ImplicitUnicode = 1;

use constant RESYNC_PRIORITY => 101;
my $SLEEP_COEF = 1;

my @certain_bids;
my $DRY_RUN;
extract_script_params(
    'bid=i@' => \@certain_bids,
    'dry-run' => \$DRY_RUN,
) || exit(1);


$log->out('START');

my $total_declined = 0;
foreach my $shard (ppc_shards()) {
    $log->msg_prefix("[shard $shard]");
    while (my $banners = get_next_video_additions($shard, \@certain_bids)) {
        my $declined_banners = expose_moderation_reasons($banners);
        $total_declined += scalar @$declined_banners;
        $log->out(sprintf "found %d banners to decline", scalar @$declined_banners);
        if (@$declined_banners) {
            decline_banners($shard => $declined_banners);
        }
    }
}

$log->out(sprintf 'total declined videos: %d', $total_declined);
$log->out('FINISH');

sub get_next_video_additions {

    my ($shard, $bids) = @_;

    state $last_pk = 0;
    state $last_shard = 0;
    if ($last_shard != $shard) {
        $last_pk = 0;
        $last_shard = $shard;
    }

    my $banners = get_all_sql(PPC(shard => $shard),
                ["SELECT 
                   b.bid, b.cid, b.flags, b.body, b.title, b.href, dh.display_href, IFNULL(fd.filter_domain, b.domain) AS domain,
                   b.statusActive, br.categories_bs, bp.banner_creative_id
                 FROM banners_performance bp
                 LEFT JOIN banner_display_hrefs dh ON dh.bid = bp.bid
                 JOIN banners b ON b.bid = bp.bid
                 LEFT JOIN filter_domain fd ON fd.domain = b.domain
                 LEFT JOIN catalogia_banners_rubrics br ON br.bid = bp.bid",
                 WHERE => {
                     'bp.banner_creative_id__gt' => $last_pk,
                     (@$bids ? ('b.bid' => $bids) : ()),
                     'b.banner_type' => 'text' 
                 },
                 "ORDER BY bp.banner_creative_id",
                 "LIMIT 10000"]);

    $last_pk = $banners->[-1]->{banner_creative_id} if @$banners;

    $log->out(sprintf "selected next 10_000 video PK - %d", $last_pk);

    return @$banners ? $banners : undef;
}

sub expose_moderation_reasons {
    my $banners = shift;

    my @declined_banners;
    for my $banner (@$banners) {
        my @reasons;
        $banner->{flags} ||= '';
        
        push @reasons, {id => 370} if $banner->{flags} =~ /\blottery\b/;
        push @reasons, {id => 371} if $banner->{flags} =~ /\b(project_declaration|realty)\b/ ;
        push @reasons, {id => 372} if $banner->{flags} =~ /\b(finance|banks|forex)\b/;
        push @reasons, {id => 373} if $banner->{flags} =~ /\bdistance_sales\b/;

        push @reasons, {id => 361} if $banner->{categories_bs} && $banner->{categories_bs} =~ /\b200027676\b/;
        
        push @reasons, {id => 369} if any { $banner->{$_} && $banner->{$_} =~ /(?i)ЖСК|ЖНК/ } qw/tile body href display_href domain/;

        next unless @reasons;
        $banner->{reasons} = \@reasons;
        push @declined_banners, $banner;
    }
    return \@declined_banners;
}

sub decline_banners {
    my ($shard, $banners) = @_;

    my $bid_client_id = get_key2clientid(bid => [map { $_->{bid} } @$banners]);
    my $mysql_now = DateTime::Format::MySQL->format_datetime(now());
    my (@to_insert, @banner_creative_id, @resync);
    for my $banner (@$banners) {
        push @banner_creative_id, $banner->{banner_creative_id};
        push @to_insert, [
            'video_addition',
            $banner->{banner_creative_id},
            $bid_client_id->{$banner->{bid}},
            $banner->{cid},
            'Yes',
            'No',
            'No',
            $mysql_now,
            YAML::Syck::Dump($banner->{reasons}),
        ];
        push @resync, {
            cid => $banner->{cid},
            bid => $banner->{bid},
            priority => $banner->{statusActive} eq 'Yes' ? RESYNC_PRIORITY : int(0.8 * RESYNC_PRIORITY)
        };
        $log->out("will update banner " . to_json($banner));
    }

    if (!$DRY_RUN) {
        my $relax = relaxed_guard(times => $SLEEP_COEF);
        do_mass_insert_sql(PPC(shard => $shard),
          q[INSERT mod_reasons(type, id, ClientID, cid, statusSending, statusModerate, statusPostModerate, timeCreated, reason) VALUES %s
            ON DUPLICATE KEY UPDATE statusSending = 'Yes', statusModerate = 'No', statusPostModerate = 'No',
                                    timeCreated = VALUES(timeCreated), reason = VALUES(reason)],
          \@to_insert);
        do_update_table(PPC(shard => $shard),
          banners_performance => {
              statusModerate => 'No'
          }, where => {banner_creative_id => \@banner_creative_id});
        bs_resync(\@resync);
    }
}

