#!/usr/bin/perl

use my_inc "../..";


=head1 DESCRIPTION

  удаляем кампанию 7592828: клиенту по ошибке дали выбрать рубли и создать в них кампанию, хотя мог только в гривнах

=cut

use strict;
use warnings;

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use ScriptHelper;
use RBAC2::Extended;
use Campaign;
use PrimitivesIds;

use utf8;

local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

my $cid = 7592828;
my $login = 'serv-site';
my $uid = get_uid(login => $login);

$log->out('START');

$log->out("Resetting sum_to_pay on campaign $cid of user $login");
do_update_table(PPC, 'campaigns', {sum_to_pay => 0}, where => {cid => $cid, uid => $uid});

$log->out("Deleting campaign $cid");

my $rbac = eval { RBAC2::Extended->get_singleton(1) }
    or $log->die("error getting RBAC instance: $@");

del_camp($rbac, $cid, $uid, force => 1);

$log->out('FINISH');
