#!/usr/bin/perl

=head1 DESCRIPTION

Поиск по логу скрипта del_outdated_geo.pl криво исправленных геотаргетингов
и подготовка данных для protected/one-shot/fix_geo_by_list.pl

usage:
  zcat /mnt/remote-log-rfs/ppcback01i/protected/201610/del_outdated_geo.log.20161013.gz | protected/one-shot/del_outdated_geo_check_log.pl > list
  protected/one-shot/fix_geo_by_list.pl --data list

=cut


use Direct::Modern;
use my_inc "../..";

use GeoTools;

while (my $line = <>) {
    my ($from_geo) = $line =~ /from (\S+) to/;
    next if !$from_geo;

    my ($to_geo) = $line =~ /to (\S+)/;

    my $new_to_geo = GeoTools::substitute_temporary_geo($from_geo);
    next if $new_to_geo eq $to_geo;

    my ($object, $id) = $line =~ /on (\S+) (\d+)/;
    croak $line if !$id;
    $object = 'mgid'  if $object =~ 'HASH';
    say join "\t" => ($object, $id, $to_geo, $new_to_geo);

#    exit if our $c++ > 10000;
}

