#!/usr/bin/perl

use Direct::Modern;
use my_inc '../..';

use Yandex::DBTools;
use Yandex::DBShards;

use Settings;
use ScriptHelper;
use PrimitivesIds;
use Campaign;
use RBACElementary;
use RBACDirect;
use RBAC2::Extended;

=head1 SYNOPSIS

простенький маленький скрипт для удаления клиента из разработческой базы
компиляция из ppcClearEmptyCampaigns и ppcClearEmptyClients

=cut

$log->out('START');

my @LOGINS;
my $FORCE;
ScriptHelper::extract_script_params(
    "login=s" => \@LOGINS,
    "force"   => \$FORCE,
);

my $rbac = RBAC2::Extended->get_singleton(1);
main();

$log->out('FINISH');

sub main {
    for my $login (@LOGINS) {
        my $g = $log->msg_prefix_guard("[login=$login]");
        my $passport_uid = Primitives::get_uid_by_login($login);
        $log->out("passport uid: $passport_uid");
        my $shard = get_shard(login => $login);
        if (!$shard) {
            delete_from_rbac([$passport_uid]);
            $log->out(" shard is undefined - skip");
            next;
        }
        my $ClientID = get_clientid(login => $login);
        my $uids = get_uids(ClientID => $ClientID);

        if (!can_delete_client($ClientID)) {
            $log->out(" skip, use --force if you really want to delete this client");
            next;
        }
        for my $camp (@{get_all_sql(PPC(ClientID => $ClientID), [ "SELECT cid, uid FROM campaigns", WHERE => { uid => $uids } ])}) {
            $log->out("delete campaign $camp->{cid}");
            Campaign::del_camp($rbac, $camp->{cid}, $camp->{uid}, force => 1, ignore_rbac_errors => 1);
        }

        delete_from_rbac($uids);

        for my $uid (@$uids) {
            $log->out("delete user $uid");
            User::delete_user_from_db($uid);
        }
        $log->out("delete users from ppcdict new_users_data: ", $uids);
        do_delete_from_table(PPCDICT, 'new_users_data', where => {uid => $uids});
    }
}

sub can_delete_client {
    my ($ClientID) = @_;
    my $payed_camps = get_one_field_sql(PPC(ClientID => $ClientID),
        "SELECT count(*) FROM users u join campaigns c using (uid) WHERE u.ClientID = ? and (c.OrderID > 0 or c.sum > 0)", $ClientID);
    $log->out(" client has $payed_camps payed camps");
    return $payed_camps == 0 || $FORCE;
}

sub delete_from_rbac {
    my ($uids) = @_;
    $log->out("delete from rbac users ".join(",", @$uids));

    for my $uid (@$uids) {
        my $rbac_info = rbac_who_is_detailed($rbac, $uid);
        if ($rbac_info && $rbac_info->{is_internal_user}) {
            if ($rbac_info->{is_superteamleader}) {
                rbac_drop_user($rbac, $uid, 'superteamleader');
            }
            if ($rbac_info->{is_teamleader}) {
                rbac_drop_user($rbac, $uid, 'teamleader');
            }
            my $ret = rbac_drop_user($rbac, $uid, $rbac_info->{role});
            if ($ret) {
                $log->out("can't drop user from rbac: $ret");
            }
        }
    }

    for my $uid (@$uids) {
        for my $manager_uid (@{rbac_get_managers_of_client($rbac, $uid)}) {
            rbac_unbind_manager($rbac, $manager_uid, $uid);
        }
    }

    my $client_uid2agency_uids = rbac_mass_get_agencies_of_clients($rbac, $uids);
    while(my ($uid, $agencies) = each %$client_uid2agency_uids) {
        for my $agency_uid (@$agencies) {
            rbac_unbind_agency($rbac, $agency_uid, $uid);
        }
    }

    my $client_id_rbac = rbac_get_client_clientid_by_uid($uids->[0]);
    if ($client_id_rbac) {
        my $chief_rep = rbac_get_chief_rep_of_client_rep($uids->[0]);
        my $other_reps = [ grep {$chief_rep != $_}
            @{rbac_get_main_reps_of_client($client_id_rbac)}
        ];

        # удаляем всех представителей из rbac
        for my $rep_uid (@$other_reps) {
            my $rbac_res = rbac_drop_client_rep($rbac, $client_id_rbac, $rep_uid);
            die "cant drop in rbac: client_id: $client_id_rbac uid: $rep_uid error: $rbac_res" if $rbac_res;
        }

        my $rbac_res = rbac_drop_client($rbac, $chief_rep);
        if ($rbac_res) {
            # это кампании которые висят не на главном представителе
            $log->out("Can't delete chief client uid $chief_rep - rbac error: $rbac_res");
        }
    }
}
