#!/usr/bin/perl

=head1 DESCRIPTION

=cut

use Direct::Modern;
use my_inc "../..";

use Yandex::DBTools;

use ShardingTools;
use ScriptHelper;
use Settings;

extract_script_params(
    'f|feature-name=s' => \my $feature_name,
    'dry-run!' => \my $dry_run,
);


croak "No feature name given, stop"  if !$feature_name;

my $feature_id = get_one_field_sql(PPCDICT, [
        'SELECT feature_id FROM features',
        WHERE => { feature_text_id => $feature_name },
        LIMIT => 1,
    ]);
croak "Feature <$feature_name> not found, stop"  if !$feature_id;

$log->out("Going to remove feature <$feature_name>, id=$feature_id");

do_in_transaction {
    for my $shard (ppc_shards()) {
        $log->out("processing shard #$shard");
        _del(PPC(shard => $shard), clients_features => {feature_id => $feature_id});
    }

    $log->out("processing ppcdict");
    _del(PPCDICT, features => {feature_id => $feature_id});
};

$log->out("Feature <$feature_name>, id=$feature_id removed successfully");



sub _del {
    my ($dbh, $table, $condition) = @_;
    my $count;
    if ($dry_run) {
        $count = get_one_field_sql($dbh, [
                'SELECT count(*) FROM', $table,
                WHERE => $condition,
            ]);
        $log->out("DRY: removal of $count records from $table skipped");
    }
    else {
        $count = do_delete_from_table($dbh, $table,
            where => $condition
        );
        $log->out("Removed $count records from $table");
    }
    return $count;
}
