#!/usr/bin/perl

use Direct::Modern;

=head1 DESCRIPTION

    Удаление баннера в некорректном состоянии. Обязательный параметр --bid - номер баннера.

    Пользоваться ОСТОРОЖНО, т.к. нет никаких проверок о допустимости удаления баннера!

    protected/one-shot/delete_banner.pl --bid 585251594

=cut

use my_inc '../..', for => 'protected';

use Models::Banner qw/ delete_banners /;
use PrimitivesIds qw/ get_cid /;
use Settings;
use ScriptHelper;

my $bid;

extract_script_params(
    'bid=i' => \$bid,
);

if (!$bid) {
    die "--bid required";
}

$log->out('START');

delete_banner($bid);

$log->out('FINISH');

sub delete_banner {
    my ($bid) = @_;

    my $cid = get_cid(bid => $bid);

    if (!$cid) {
        $log->die("Banner $bid not exists!");
    }

    my $cnt = delete_banners( $cid, [{bid => $bid}], {skip_checks => 1} );

    $log->out("Banner $bid deleted");
}
