#!/usr/bin/perl

use my_inc "../..";


=head1

	Удаляет ставки по рубрикам
	Опиционалые параметры:
        --cid - кампании для обработки, можно диапазоны. по умолчанию - все

=cut 

use 5.010;
use strict;
use warnings;
use utf8;

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Yandex::Overshard;
use Yandex::HashUtils;

use JSON;
use List::Util qw/ max sum /;
use List::MoreUtils qw/ all /;


my $CHUNK_SIZE = 1000;


my $cid_str;
my $SLEEP_COEF = 1;
extract_script_params( 
    'cid|cids=s' => \$cid_str, 
    "sleep-coef=i" => \$SLEEP_COEF,
);

my ($cid_start, $cid_end) = (0, q{});
if ( $cid_str && (my ($from, $is_range, $to) = $cid_str =~ / ^ (\d+) (?: (- | \.\.) (\d+)? )? /xms) ) {
    $cid_start = $from;
    $cid_end   = $is_range ? $to || q{} : $from;
}


# описание, какие таблицы чистить,
# и по каким полям в них выбирать строки, чтобы не попасть на fullscan
# первое поле - fk на bids.id

my @tables = (
    [bids_href_params => [qw/id cid/]],
    [bids_phraseid_associate => [qw/ bids_id cid /]],
    [bids_manual_prices => [qw/ id cid /]],
#    [bids_bs_history => [qw/ id cid /]],
#    [bids_phraseid_history => [qw/ id cid /]],
#    [bs_auction_stat => [ undef, qw/ pid PhraseID / ]],
#    [bs_auction_stat_context => [ undef, qw/ pid PhraseID / ]],
    [bs_auction_stat_off => [ undef, qw/ pid PhraseID / ]],
    [bids => [ 'id' ]],
    [bids_arc => [qw/ id cid /]],
);

$log->out("START for cids $cid_start-$cid_end");

while (1) {
    my $st = time;

    my $cid_cond = $cid_end
        ? { cid__between => [ $cid_start, $cid_end ] }
        : { cid__ge => $cid_start };
    my $camps =
        overshard order => 'cid:num', limit => $CHUNK_SIZE,
        get_all_sql( PPC(shard => 'all'), [
            'SELECT cid, archived FROM campaigns',
            WHERE => $cid_cond,
            'ORDER BY cid',
            LIMIT => $CHUNK_SIZE
        ]);
    last if !@$camps;

    for my $camp ( @$camps ) {
        my %count;
        my $cid = $camp->{cid};

        my $bids = get_all_sql( PPC(cid => $cid), 
            'SELECT id, PhraseID, pid FROM bids WHERE cid = ? AND numword = 0
            UNION
            SELECT id, PhraseID, pid FROM bids_arc WHERE cid = ? AND numword = 0',
            $cid, $cid
        );


        if ( $bids && @$bids ) {
            for my $item ( @tables ) {		
                my ($table, $id_fields) = @$item;
                my @id_fields = @$id_fields;

                my %cond;
                # если есть ключ на bids.id - ищем по нему 
                if ( my $bid_id_name = shift @id_fields ) {
                    $cond{$bid_id_name} = [ map {$_->{id}} @$bids ];
                    # !!! пока считаем, что второе поле может быть только cid
                    $cond{cid} = $cid  if @id_fields;
                }
                # ... а если нет - вываливаем полный список в _OR
                else {
                    my @subconds =
                        #пропускаем, только если все поля условия ненулевые!
                        grep { my $cond = $_; all {$cond->{$_}} keys %$cond }
                        map {hash_cut($_, @id_fields)}
                        @$bids;
                    $cond{_OR} = [ map {(_AND => $_)} @subconds ]  if @subconds;
                }

                next if !%cond;

                $count{$table} = do_delete_from_table( PPC(cid => $cid), $table, where => \%cond );
            }
        }

        my $mbid_ids = get_one_column_sql( PPC(cid => $cid),
            'SELECT id FROM mediaplan_bids WHERE cid = ? AND numword = 0',
            $cid
        ) || [];

        if ( @$mbid_ids ) {
            $count{mediaplan_bids} = do_delete_from_table( PPC(cid => $cid), 'mediaplan_bids',
                where => { id => $mbid_ids }
            );
        }

        my $num_deleted = sum values %count;
        next if !$num_deleted;

        $log->out("cid $cid: $num_deleted ".to_json(\%count));
    }

    $cid_start = $camps->[-1]->{cid} + 1;

    if (my $pause = $SLEEP_COEF * (time - $st)) {
        $log->out(sprintf "sleep %f", $pause);
        sleep $pause;
    }
}

$log->out('FINISH');


