#!/usr/bin/perl

use my_inc "../..";


=head1

	Удаляет все записи из таблиц clients и addresses, которые не используются в users.
	Опиционалые параметры:
		--clients - почистить таблицу clients
		--addresses - почистить таблицу addresses

=cut 

use strict;
use warnings;

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Yandex::ListUtils qw/chunks/;
use ShardingTools;

use utf8;

my ($CLIENTS, $ADDRESSES) = (0,0);
extract_script_params(
    "clients" => \$CLIENTS,
    "addresses" => \$ADDRESSES,
);

$log->out('START');
my $chunk_step = 10_000;

if ($CLIENTS) {
    $log->out("clear clients table");
    my $clients = [];
    my $counter = 0;
    foreach my $shard (ppc_shards()) {
        my $clients = get_one_column_sql(PPC(shard => $shard), "SELECT ClientID FROM clients LEFT JOIN users u USING(ClientID) WHERE u.ClientID IS NULL") || [];
        foreach my $chunk (chunks($clients, $chunk_step)) {
            my $old_clients = get_all_sql(PPC(shard => $shard), ["SELECT * FROM clients", where => {ClientID => $chunk}]);
            $counter += do_delete_from_table(PPC(shard => $shard), 'clients', where => {ClientID => $chunk});
            $log->out({"for deleting:" => $old_clients});
        }
    }
    $log->out(sprintf("total amount: %d", $counter));
}

if ($ADDRESSES) {
    $log->out("clear addresses table");
    my $counter = 0;
    foreach my $shard (ppc_shards()) {
        my $aids = get_one_column_sql(PPC(shard => $shard), "SELECT aid FROM addresses LEFT JOIN users u USING(ClientID) LEFT JOIN vcards v ON aid=address_id 
                                            WHERE u.ClientID IS NULL AND v.vcard_id IS NULL") || [];
        foreach my $chunk (chunks($aids, $chunk_step)) {
            my $old_aids = get_all_sql(PPC(shard => $shard), ["SELECT * FROM addresses", where => {aid => $chunk}]);
            $counter += do_delete_from_table(PPC(shard => $shard), 'addresses', where => {aid => $chunk});
            $log->out({"for deleting:" => $old_aids});
        }
    }
    $log->out(sprintf("total amount: %d", $counter));
}

$log->out('FINISH');

exit;
