#!/usr/bin/perl

use my_inc "../..";

=head1 DESCRIPTION

  Удаляем из таблицы ppc.mod_reasons причины отклонения для удаленных баннеров, контактной информации, быстрых ссылок и картинок

=cut

use strict;
use warnings;

use lib::abs '..';

use Settings;
use ScriptHelper;
use ShardingTools;
use Yandex::DBTools;
use Yandex::ListUtils;

use utf8;


$log->out('START');
foreach my $shard_id (ppc_shards()) {
    # ищем записи в таблице mod_reasons
    $log->out("Select bad records from ppc.mod_reasons, shard: $shard_id");
    my $rid_chunk_size = 1_000_000;
    my ($max_rid, $min_rid) = get_one_line_array_sql(PPC(shard => $shard_id), "select max(rid), min(rid) from mod_reasons");
    $log->out("Min rid = $min_rid. Max rid = $max_rid");
    my $current_rid = $min_rid;
    # записи выбираем из таблицы чанками по $rid_chunk_size
    while ($min_rid < $max_rid) {
        $current_rid += $rid_chunk_size;
        $log->out("Search bad records between rid $min_rid and $current_rid");
        my $bad_recs = get_all_sql(PPC(shard => $shard_id), "select m.rid, m.id, m.type, m.statusSending, m.statusModerate, m.statusPostModerate, m.timeCreated, m.reason 
                                                    from mod_reasons m 
                                                    left join phrases p on m.id = p.pid where 
                                                    p.pid IS NULL AND m.type IN ('phrases') 
                                                    and m.rid between $min_rid and $current_rid") || [];
        my $bad_recs2 = get_all_sql(PPC(shard => $shard_id), "select m.rid, m.id, m.type, m.statusSending, m.statusModerate, m.statusPostModerate, m.timeCreated, m.reason 
                                                    from mod_reasons m 
                                                    left join campaigns c on m.id = c.cid where 
                                                    c.cid IS NULL AND m.type IN ('campaign') 
                                                    and m.rid between $min_rid and $current_rid") || [];
        
        my $bad_recs_count = push (@{$bad_recs}, @{$bad_recs2});

        if ($bad_recs_count > 0) {
            $log->out("Found $bad_recs_count bad records");
            # удаляем найденые записи чанками по $chunk_size
            my $chunk_num = 1;
            my $chunk_size = 10_000;
            $log->out('Delete bad records from ppc.mod_reasons');
            for my $chunk (chunks($bad_recs, $chunk_size)) {
                $log->out("Chunk: $chunk_num\t".(($bad_recs_count > 0)?$bad_recs_count:0)." records last");
                $log->out($chunk);
                my @chunk_rids = map { $_->{rid} } @{$chunk};
                do_sql(PPC(shard => $shard_id), ["delete from mod_reasons", where => { rid => \@chunk_rids }]);
                $chunk_num++;
                $bad_recs_count -= $chunk_size;            
            }
        } else {
            $log->out("Bad records not found between rid $min_rid and $current_rid");
        }
        $min_rid = ++$current_rid;
    }
}
$log->out('FINISH');
