#!/usr/bin/perl

=head1 DESCRIPTION

Выключаем все геоконтекстовые кампании

=cut

use Direct::Modern;

use my_inc '../..';

use Settings;
use ScriptHelper;

use Yandex::DBTools;
use Time::HiRes qw/sleep/;
use Campaign;
use MailNotification;

my $SLEEP_COEF = 0.005;
extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
);

$log->out('START');

# context
my $UID = 112635943; # yndx.geomanager
MailNotification::save_UID_host($UID);

# кампаний ~10000, загружаем сразу все
my $camps = get_all_sql(PPC(shard => 'all'), [
        'select cid, uid from campaigns where type="geo" and statusShow="Yes"'
    ]);
$log->out(sprintf("going to stop %s campaigns", scalar @$camps));

for my $i (0 .. $#$camps) {
    my $camp = $camps->[$i];
#    last if $i > 10; # debug

    $log->out("$i: stopping cid=$camp->{cid}");
    stop_camp($camp->{uid}, $camp->{cid});
    sleep $SLEEP_COEF;
}

$log->out('FINISH');
