#!/usr/bin/env perl

# скопировано с миграции 20160330_enable_wallet_for_easy

use Direct::Modern;

use my_inc '../..';

use Settings;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::YT::Table;

use Campaign::Types;
use DirectContext;
use RBAC2::Extended;
use RBACElementary;
use ShardingTools qw/foreach_shard_parallel_verbose/;
use EnvTools qw//;
use Wallet qw//;
use Tools qw//;

use ScriptHelper;

Tools::set_yt_environment();

my $types_str = "'" . join("', '", @{get_camp_kind_types('under_wallet')}) . "'";
# 'content_promotion', 'cpm_banner', 'cpm_deals', 'cpm_price', 'cpm_yndx_frontpage', 'dynamic', 'mcbanner', 'mobile_content', 'performance', 'text'

my $uid;
extract_script_params(
    'uid=i' => \$uid,
);

$log->out($uid ? "START (uid=$uid)" : "START");

my $uid_shard = $uid ? get_shard(uid => $uid) : undef;
$log->die("Cannot find uid $uid") if $uid && !$uid_shard;

my $client_ids;

my $table_path = '//home/direct/test/sco76/client_ids_to_enable_wallet';

if ($uid) {
    $client_ids = [rbac_get_client_clientid_by_uid($uid)];
} else {
    my $table = Yandex::YT::Table->new($table_path);
    unless ($table->exists()) {
        $log->die("Table $table_path doesn't exist");
    }

    $log->out("Let's import data from YT");
    my $reader = $table->reader();
    while(my $r = $reader->next()) {
        push @$client_ids, $r->{client_id};
    }
    $log->out("Finished reading a table from YT");
}

my %shard2client_id = map {$_->{shard} => $_->{ClientID}} sharded_chunks(ClientID => $client_ids, chunk_size => 0);

foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;

    if (($uid_shard && $shard != $uid_shard) || !$shard2client_id{$shard} || !@{$shard2client_id{$shard}}) {
        return;
    }

    my $rbac = eval { RBAC2::Extended->get_singleton(1) } or $log->die("Error initialising RBAC: $@");

    for my $client_id (@{$shard2client_id{$shard}}) {
        $log->msg_prefix("[shard $shard, client_id $client_id] ");
        $log->out("Processing next client");

        my $client_users_data = get_one_line_sql(PPC(shard => $shard), "
            SELECT u.uid AS uid,
                    cl.agency_client_id,
                    u.login,
                    IFNULL(cl.work_currency, 'YND_FIXED') AS work_currency,
                    COUNT(IF(c.wallet_cid <> 0, 1, NULL)) AS has_camps_under_wallet,
                    COUNT(IF(c.type IN ($types_str), 1, NULL)) AS has_camps,
                    COUNT(IF(c.AgencyID <> 0, 1, NULL)) AS has_agency_camps
            FROM clients cl
            JOIN users u ON (cl.ClientID = u.ClientID)
            JOIN clients_options co ON (co.ClientID = cl.ClientID)
            LEFT JOIN campaigns c ON (
                cl.ClientID = c.ClientID AND
                IFNULL(c.currency, 'YND_FIXED') = IFNULL(cl.work_currency, 'YND_FIXED')
            )
            WHERE u.rep_type = 'chief' AND cl.role = 'client' AND cl.ClientID = ?
        ", $client_id);

        if ($client_users_data->{has_camps_under_wallet}) {
            $log->out("Will not process, client has camps under a wallet");
            next;
        }
        if (!$client_users_data->{has_camps}) {
            $log->out("Will not process, client has no compatible camps");
            next;
        }
        if ($client_users_data->{agency_client_id}) {
            $log->out("Will not process, client has an agency");
            next;
        }
        if ($client_users_data->{has_agency_camps}) {
            $log->out("Will not process, client has agency campaigns");
            next;
        }
        if ($client_users_data->{work_currency} eq 'YND_FIXED') {
            $log->out("Will not process, client has YND_FIXED as a currency");
            next;
        }

        my $context = DirectContext->new({
            UID => $client_users_data->{uid},
            uid => $client_users_data->{uid},
            client_chief_uid => $client_users_data->{uid},
            client_client_id => $client_id,
            login_rights => {},
            rbac => $rbac,
            is_beta => EnvTools::is_beta(),
        });

        my $result;
        eval {
            $result = Wallet::enable_wallet($context, $client_users_data->{work_currency}, 0, allow_wallet_before_first_camp => 1);
            1;
        } or do {
            $result = {error => $@};
        };

        if ($result and $result->{wallet_cid}) {
            do_sql(PPC(shard => $shard),
                    "update campaigns wc,
                    (select ifnull(max(c.statusMail),0) maxStatusMail from campaigns c where c.uid=? and c.wallet_cid=?) t
                    set wc.statusMail = t.maxStatusMail where wc.cid=?",
                    $context->client_chief_uid, $result->{wallet_cid}, $result->{wallet_cid}
            );
        }

        $log->out({ClientID => $client_id, uid => $context->client_chief_uid, login => $client_users_data->{login}, result => $result});
    }
});

$log->out('FINISH');
