#!/usr/bin/perl

use my_inc "../..";

use strict;
use warnings;
use utf8;

use List::MoreUtils qw{uniq all notall any};

use Settings;
use ScriptHelper;
use Yandex::DBTools;
use RBAC2::Extended;
use RBACElementary;
use Rbac qw/:const/;
local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

my $file;
extract_script_params( 'logins=s' => \$file );

unless($file){
    printf("Usage %s --logins=filename\n", $0);
    exit 0;
}

my $agencies_logins = parse_file($file);
my $agencies = get_all_agencies_uids($agencies_logins);
get_all_clients_domains($agencies);
print_csv($agencies);


# ========== SUBROUTINES ==========
sub parse_file
{
    open my $fh, '<', $file or die "Can't open file '$file': $!";

    my $logins = [];
    while(<$fh>){
        chomp($_);
        push(@$logins, $_);
    }

    close $fh;
    return $logins;
}

sub get_all_agencies_uids
{
    my $logins = shift;

    my $rbac = RBAC2::Extended->get_singleton(1);

    my $agencies_logins_and_uids = {};
    for my $login (@$logins){
        my $rep_uid = get_one_field_sql(PPC, "select uid from users where login = ?", $login);
        my $agency_clientid = rbac_get_agency_clientid_by_uid( $rep_uid);
        my $agency_reps = Rbac::get_reps(ClientID => $agency_clientid, role => $ROLE_AGENCY);
        $agencies_logins_and_uids->{$login}->{reps} = $agency_reps;
    }

    return $agencies_logins_and_uids;
}

sub get_all_clients_domains
{
    my $agencies = shift;
    for my $agency_login (keys %$agencies){
        my $clients = get_one_column_sql(PPC, ["select distinct(uid) from campaigns",  where => { archived => 'No', AgencyUID => $agencies->{$agency_login}->{reps}}]) || [];
        $clients = join(',', @$clients);
        my $select = sprintf("select c.uid, b.domain from campaigns c join banners b using(cid)  where c.uid in (%s) and b.domain is not null group by 1,2\n", $clients);
        my $domains = get_all_sql(PPC, $select);
        my $clients_domains = {};
        for my $domain (@$domains){
            my $uid = $domain->{uid};
            my ($zone) = $domain->{domain} =~ /\.(\w+)$/;
            $clients_domains->{$uid}->{$zone} = 1;
        }
        $agencies->{$agency_login}->{clients_domains} = $clients_domains;
    }
}

sub print_csv
{
    my $data = shift;
    printf("%s,%s,%s,%s,%s\n", 'agency', 'ru_rf', 'ua', 'not_ua_ru_rf', 'ru_ua');
    for my $agency (keys %$data){
        my $count_ua = 0;
        my $count_ru_rf = 0;
        my $count_not_ua_ru_rf = 0;
        my $count_ru_rf_ua = 0;
        my $clients = $data->{$agency}->{clients_domains};
        for my $client (keys %$clients){
            my @domains = keys %{$clients->{$client}};
            if (all { /ua/ } @domains){
                ++$count_ua;
            } elsif (all { /(ru|рф)/ } @domains){
                ++$count_ru_rf;
            } elsif (notall { /(ru|рф|ua)/ } @domains){
                ++$count_not_ua_ru_rf;
            } elsif(
                (any { /(ru|рф)/ } @domains)
                && (any { /ua/ } @domains) ){
                ++$count_ru_rf_ua;
            } else {
                die;
            }
        }
        printf("%s,%s,%s,%s,%s\n", $agency, $count_ru_rf, $count_ua, $count_not_ua_ru_rf, $count_ru_rf_ua);
    }
}
