#!/usr/bin/perl


use Direct::Modern;

use my_inc '../..';

use Yandex::DBTools;
use Yandex::DBShards;

use ScriptHelper;
use Settings;
use ShardingTools qw(ppc_shards);
use Yandex::ListUtils qw/chunks/;

$log->out('START');

for my $shard (ppc_shards()) {
    $log->out("updating shard: $shard");
    while (my $items = get_next_rows($shard)) {
        $log->out(sprintf "found %d records", scalar @$items);
        for my $chunk (chunks $items, 500) {
            my @items_to_insert;
            for my $item (@$chunk) {
                if (!$item->{image_type}) {
                    $log->out("ClientID=$item->{ClientID} image_hash=$item->{image_hash}: format missing, skipped");
                    next;
                }
                $log->out("ClientID=$item->{ClientID} image_hash=$item->{image_hash}: writing to pool");
                push @items_to_insert, [
                    get_new_id('banner_images_pool_id', ClientID => $item->{ClientID}),
                    $item->{ClientID},
                    $item->{image_hash},
                    'lost+found',
                ];
            }
            next if !@items_to_insert;

            do_mass_insert_sql(PPC(shard => $shard),
                'INSERT INTO banner_images_pool (imp_id, ClientID, image_hash, name) VALUES %s',
                \@items_to_insert,
            );
            $log->out(sprintf "%d lines inserted", scalar @items_to_insert);
        }
    }
}

$log->out('FINISH');

sub get_next_rows {
    my ($shard) = @_;

    my $rows = get_all_sql(PPC(shard => $shard), [
            "SELECT DISTINCT ClientID, image_hash, image_type
            FROM images i
            JOIN banners b using(cid, pid, bid)
            JOIN campaigns c USING(cid)
            JOIN users u USING(uid)
            LEFT JOIN banner_images_pool bip using(ClientID, image_hash)
            LEFT JOIN banner_images_formats bif USING(image_hash)",
            WHERE => {
                'bip.image_hash__is_null' => 1,
                'bif.image_hash__is_not_null' => 1,
            },
            LIMIT => 1000,
        ]);
    return @$rows ? $rows : undef;
}
