#!/usr/bin/perl

use my_inc "../..";


use strict;
use warnings;

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use ScriptHelper;

use List::MoreUtils qw/none/;

local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

my ($FILL_EVIDENT_CLIENTID, $FILL_OTHER_CLIENTID, $DELETE_UNUSED, $ALL) = (0,0,0,0);
extract_script_params("fill_evident_ClientID" => \$FILL_EVIDENT_CLIENTID,
           "fill_others_ClientID" => \$FILL_OTHER_CLIENTID,
           "delete_unused" => \$DELETE_UNUSED,
          );

$ALL = 1 if (none {$_} ($FILL_EVIDENT_CLIENTID, $FILL_OTHER_CLIENTID, $DELETE_UNUSED));

$log->out("START");
#Step1: Берем минус-слова, которые принадлежат только одному клиенту.
fill_evident_ClientID_in_minus_words() if $FILL_EVIDENT_CLIENTID || $ALL;

#Step2: Просматриваем оставшиеся минус слова и если надо, разносим по клиентам.
fill_others_ClientID_in_minus_words() if $FILL_OTHER_CLIENTID || $ALL;

#Step3: Удалить неиспользуемые минус слова. Для них мы не сможем установить владельца.
delete_unused_minus_words() if $DELETE_UNUSED || $ALL;

$log->out("FINISH");

exit;


sub fill_evident_ClientID_in_minus_words {
    # ~ 55 минут
    my $affected = do_insert_select_sql(PPC, "INSERT INTO minus_words (mw_id, ClientID) VALUES %s ON DUPLICATE KEY UPDATE ClientID = VALUES(ClientID)",
                                             "SELECT mw_id, ClientID FROM
                                              ( SELECT STRAIGHT_JOIN mw_id, uid
                                                FROM phrases JOIN campaigns USING (cid)
                                                WHERE mw_id > 0
                                                GROUP BY mw_id
                                                HAVING count(distinct uid) = 1) t
                                              JOIN users USING (uid)",
                                              dbw => PPC,
                                              max_row_for_select => 100_000);

    $log->out(sprintf("For ~%s banner ClientID were updated in minus_words table", $affected/2));
}

sub fill_others_ClientID_in_minus_words {

    my $minus_words = get_all_sql(PPC, "SELECT STRAIGHT_JOIN mw_id, mw_hash, mw_text, u.ClientID FROM phrases p 
                                        JOIN campaigns c ON c.cid = p.cid 
                                        JOIN users u USING (uid)
                                        JOIN minus_words USING(mw_id)
                                        WHERE p.mw_id > 0 AND u.ClientID > 0
                                        GROUP BY p.mw_id, u.ClientID");
    my $store = {};
    foreach my $mw (@$minus_words) {
        if (! $store->{$mw->{mw_id}}) {
            do_update_table(PPC, 'minus_words', {ClientID => $mw->{ClientID}}, where=>{mw_id => $mw->{mw_id}});
            $store->{$mw->{mw_id}} = 1;
            $log->out(sprintf("updated minus words: mw_id => %d, new ClientID => %d", $mw->{mw_id}, $mw->{ClientID}));
        } else {
            $mw->{mw_id} = get_new_id('mw_id');
            do_insert_into_table(PPC, 'minus_words', $mw);
            $log->out(sprintf("inserted minus words: mw_id => %d, new ClientID => %d", $mw->{mw_id}, $mw->{ClientID}));
        }
    }
}

sub delete_unused_minus_words {
    do_delete_from_table(PPC, 'minus_words', where=>{ClientID => 0});
}
