#!/usr/bin/perl

use my_inc "../..";


use strict;
use warnings;

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use ScriptHelper;
use Sitelinks;

use List::MoreUtils qw/none/;
local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

my ($FILL_EVIDENT_CLIENTID, $FILL_OTHER_CLIENTID, $DELETE_UNUSED, $FILL_SHARD, $ALL) = (0,0,0,0,0);
extract_script_params("fill_evident_ClientID" => \$FILL_EVIDENT_CLIENTID,
           "fill_others_ClientID" => \$FILL_OTHER_CLIENTID,
           "delete_unused" => \$DELETE_UNUSED,
           "fill_shard" => \$FILL_SHARD,
          );

$ALL = 1 if (none {$_} ($FILL_EVIDENT_CLIENTID, $FILL_OTHER_CLIENTID, $DELETE_UNUSED, $FILL_SHARD));

$log->out("START");

#Step1: Берем наборы сайтлинков, которые принадлежат только одному клиенту.
# ~ 60 мин
fill_evident_ClientID_in_sitelinks_sets() if $FILL_EVIDENT_CLIENTID || $ALL;

#Step2: Просматриваем оставшиеся сайтлинки и если надо, разносим по клиентам.
# Во время тестирования таких наборов сайтлинков нашлось около 310тыс.
# ~ 80 мин
fill_others_ClientID_in_sitelinks_sets() if $FILL_OTHER_CLIENTID || $ALL;

#Step3: Удалить неиспользуемые сайтлинки. Для них мы не сможем установить владельца.
# ~ 40 мин
delete_unused_sitelinks() if $DELETE_UNUSED || $ALL;

#Step4: Заполяем таблицу shard_inc_sitelinks_set_id
# ~ 4 мин
fill_shard_inc_sitelinks_set_id() if $FILL_SHARD || $ALL;

$log->out("FINISH");

exit;

sub fill_evident_ClientID_in_sitelinks_sets {
    # примерно 8 млн
    my $affected = do_insert_select_sql(PPC, "INSERT INTO sitelinks_sets (sitelinks_set_id, ClientID) VALUES %s ON DUPLICATE KEY UPDATE ClientID = VALUES(ClientID)",
                                             "SELECT sitelinks_set_id, ClientID FROM
                                              ( SELECT b.sitelinks_set_id, c.uid
                                                FROM banners b 
                                                     JOIN campaigns c on c.cid = b.cid
                                                WHERE b.sitelinks_set_id > 0
                                                GROUP BY b.sitelinks_set_id
                                                HAVING count(distinct c.uid) = 1) t
                                              JOIN users USING (uid)",
                                              max_row_for_select => 100_000);
    $log->out(sprintf("For ~ %s sitelinks sets ClientID were updated in sitelinks_sets table", $affected/2));
}

sub fill_others_ClientID_in_sitelinks_sets {

    my $all_sl_sets = get_all_sql(PPC, "SELECT sitelinks_set_id, ClientID, uid FROM 
                                        ( SELECT b.sitelinks_set_id, c.uid 
                                            FROM banners b
                                                 JOIN campaigns c ON c.cid = b.cid
                                                 JOIN sitelinks_sets ss ON ss.sitelinks_set_id = b.sitelinks_set_id
                                          WHERE b.sitelinks_set_id > 0 AND ss.ClientID=0 
                                          GROUP BY b.sitelinks_set_id, c.uid) t 
                                        JOIN users USING (uid)");

    my $store = {};
    foreach my $row (@$all_sl_sets) {
        next unless $row->{ClientID};
        # Если это первый раз встречается sitelinks_set_id, то просто апдейтим у него clientID.
        if (! $store->{$row->{sitelinks_set_id}}) {
          do_update_table(PPC, "sitelinks_sets", {ClientID => $row->{ClientID}}, where => {sitelinks_set_id => $row->{sitelinks_set_id}});
          $store->{$row->{sitelinks_set_id}} = 1;
          $log->out(sprintf("A new ClientID (%s) was set to sitelinks_set_id == %s", $row->{ClientID}, $row->{sitelinks_set_id}));
          next;
        }
        # Если это второе и более упоминание sitelinks_set_id для разных клиентов, то клонируем набор сайтлинков.
        # Извлекаем старые сайтлинки для набора.
        my $sls = Sitelinks::get_sitelinks_by_set_id($row->{sitelinks_set_id});
        # Сохраняем их же с добавлением поля ClientID. А так как оно равно 0, то сохраняются новые ссылки и набор ссылок.
        my $new_sitelilnk_set_id = Sitelinks::save_sitelinks_set($sls, $row->{ClientID});
        my $affected = do_update_table(PPC, "banners", {sitelinks_set_id=>$new_sitelilnk_set_id}, 
                                       where=>{sitelinks_set_id => $row->{sitelinks_set_id}, uid=> $row->{uid}});
        $log->out(sprintf("sitelinks_set_id: old: %s -> new %s (%s banners) with ClientID: %s, uid: %s", 
                           $row->{sitelinks_set_id}, $new_sitelilnk_set_id, $affected, $row->{ClientID}, $row->{uid}));
    }

}

sub delete_unused_sitelinks {

    do_delete_from_table(PPC, 'sitelinks_sets', where=>{ClientID => 0});

    my $sitelinks_set_ids = get_one_column_sql(PPC, "SELECT sstl.sitelinks_set_id FROM sitelinks_set_to_link AS sstl 
                                                    LEFT JOIN sitelinks_sets AS ss ON sstl.sitelinks_set_id=ss.sitelinks_set_id 
                                                    WHERE ss.sitelinks_set_id IS NULL") || [];
    while(my @chunk = splice @$sitelinks_set_ids, 0, 100_000) {
        do_delete_from_table(PPC, 'sitelinks_sets', where=>{sitelinks_set_id => \@chunk});

    };
}

sub fill_shard_inc_sitelinks_set_id {

    my $affected = do_insert_select_sql(PPC, "REPLACE INTO shard_inc_sitelinks_set_id (sitelinks_set_id, ClientID) VALUES %s", 
                                             "SELECT sitelinks_set_id, ClientID FROM sitelinks_sets ORDER BY sitelinks_set_id",
                                             dbw => PPCDICT,
                                             max_row_for_select => 100_000,
                                        );
    $log->out(sprintf("For %s sitelinks sets were updated ClientID in shard_inc_sitelinks_set_id table", $affected));    
}
