#!/usr/bin/perl

use my_inc "../..";

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use Path::Tiny;

use ScriptHelper;
use Settings;
use ShardingTools;

my %page_group_tags_by_type = (
    cpm_geoproduct => '["app-metro"]',
    content_promotion_video => '["content-promotion-video"]',
    content_promotion => '["content-promotion-collection"]',
    cpm_yndx_frontpage => '["portal-trusted"]',
);

my %target_tags_by_type = (
    cpm_geoproduct => '["app-metro"]',
    content_promotion_video => '["content-promotion-video"]',
    content_promotion => '["content-promotion-collection"]',
    cpm_yndx_frontpage => '["portal-trusted"]',
);

my $adgroup_types_for_update = [keys %page_group_tags_by_type];

my $data_path;
extract_script_params('data-file=s' => \$data_path);
my $cids_from_file = _load_cids_from_file();

$log->out('START');
foreach_shard shard => [ppc_shards()], sub {
    _process_single_shard($_[0], $cids_from_file);
};
$log->out('FINISH');

sub _load_cids_from_file {
    my @lines = path($data_path)->lines({ chomp => 1});
    $log->die("Can't open data file $data_path: $@") if !@lines;
    return [map {split /,/} @lines];
}

sub _process_single_shard {
    my ($shard, $candidate_cids) = @_;
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard_$shard]");

    my $adgroups = get_all_sql(PPC(shard => $shard), [
        'SELECT pid, adgroup_type FROM phrases',
        WHERE => {
            cid => $candidate_cids,
            adgroup_type => $adgroup_types_for_update,
        },
    ]);
    
    my @rows = map {_construct_adgroup_bs_tags_row_to_insert($_)} @$adgroups;

    $log->out("ROWS", \@rows);
    do_mass_insert_sql(PPC(shard => $shard), 'INSERT IGNORE INTO adgroup_bs_tags(pid, page_group_tags_json, target_tags_json) VALUES %s', \@rows) if @rows;
    return;
}
 
sub _construct_adgroup_bs_tags_row_to_insert {
    return [$_[0]->{pid}, $page_group_tags_by_type{$_[0]->{adgroup_type}}, $target_tags_by_type{$_[0]->{adgroup_type}}];
}

