#!/usr/bin/perl


use Direct::Modern;

use my_inc '../..';

use Yandex::DBTools;

use ScriptHelper;
use Settings;
use ShardingTools qw(ppc_shards);
use Yandex::ListUtils qw/chunks/;

$log->out('START');

for my $shard (ppc_shards()) {
    $log->out("updating shard: $shard");
    while (my $ids = get_next_rows($shard)) {
        $log->out(sprintf "found %d records", scalar @$ids);
        for my $chunk (chunks $ids, 500) {
            do_sql(PPC(shard => $shard), [
                'UPDATE banners_performance bp JOIN banners b USING(bid)',
                'SET bp.cid = b.cid',
                WHERE => {'bp.banner_creative_id' => $chunk},
            ]);
            $log->out("set cid for banner_creative_id  " . join ',', @$chunk);
        }
    }
}

$log->out('FINISH');

sub get_next_rows {
    my ($shard) = @_;

    my $rows = get_one_column_sql(PPC(shard => $shard),
                   "SELECT banner_creative_id
                   FROM banners_performance
                   WHERE cid = 0
                   LIMIT 1000");
    return @$rows ? $rows : undef;
}
