#!/usr/bin/perl

use my_inc '../..';

use Direct::Modern;

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use ShardingTools;
use Yandex::ListUtils qw/chunks/;
use BannerStorage qw//;

my $SHARD;
extract_script_params(
    'shard-id=s' => \$SHARD,
);

$log->out('START');

my %shards = ($SHARD) ? ($SHARD => 1) : map { $_ => 1 } ppc_shards();
foreach_shard_parallel_verbose($log, sub { 
    my ($shard) = @_;

    return unless $shards{$shard};
    $log->out("PROCESSING shard $shard");

    my $creatives = get_all_sql(PPC(shard => $shard), "SELECT creative_id, statusModerate FROM perf_creatives WHERE template_id IS NULL");
    my %creatives_status;
    for my $creative (@$creatives) {
        my $st = $creative->{statusModerate} =~ /(Yes|No)/ ? 'moderated' : 'in_editing';
        push @{$creatives_status{$st}}, $creative->{creative_id};
    }
    $log->out(sprintf "found %d creatives without template_id", scalar @$creatives);
    while (my ($status, $creative_ids) = each %creatives_status) {
        $log->out(sprintf "found %d creatives in status %s", scalar(@$creative_ids), $status);
        for my $chunk (chunks $creative_ids, 30) {
            my $received_creatives = BannerStorage::receive_creatives($chunk, $status);
            my %creative_template = map {$_->id => $_->template_id} @$received_creatives;
            do_update_table(PPC(shard => $shard), "perf_creatives", {
                template_id__dont_quote => sql_case(creative_id => \%creative_template)
            }, where => {creative_id => [keys %creative_template]});
            $log->out(sprintf "status %s: update template_id on creatives (%s)", $status, join ',', map { $_->id } @$received_creatives);
            my @skipped_creatives = grep { !$creative_template{$_} } @$chunk;
            if (@skipped_creatives) { 
                $log->out(sprintf "status %s: not found creatives (%s)", $status, join ',', @skipped_creatives);
            } 
        }
    }
});

$log->out('FINISH');
 
