#!/usr/bin/perl

use my_inc "../..";

=head1 DESCRIPTION

    Для всех существующих в ppc.turbolandings турболендингов записывает
    счетчики в ppc.turbolanding_metrika_counters, а цели - в ppc.turbolanding_metrika_goals

    LOG_TEE=1 ./protected/one-shot/fill_turbolanding_counters_and_goals.pl

    Параметры (для тестирования):
        shard-id -- запустить только на определенном шарде
        client-id -- запустить только для определенного клиента

    Программа работает параллельно с каждым шардом. Можно перезапускать.

=cut

use Direct::Modern;
use open ':std' => ':utf8';

use Settings;
use ScriptHelper 'Yandex::Log' => 'messages';

use Yandex::DBTools;
use Yandex::DBShards;
use ShardingTools qw/ppc_shards/;
use Yandex::ListUtils qw/chunks/;
use Try::Tiny qw/try catch/;
use JSON qw/from_json/;

my $CHUNK_SIZE = 300;
my ($ONLY_SHARD_ID, $CLIENT_ID);
extract_script_params(
    'shard-id:i' => \$ONLY_SHARD_ID,
    'client-id:i'  => \$CLIENT_ID,
);

$log->out('START');

my $script_name = get_script_name();
my $shard_results = foreach_shard_parallel(shard => [defined $ONLY_SHARD_ID ? $ONLY_SHARD_ID : ppc_shards()], sub {
    my ($shard) = @_;

    $log->msg_prefix("shard=$shard");
    $log->out('START');
    
    try {
        #Максиамальнон количество турболендингов на одном шарде сейчас 6155, выбираем все разом
        my  $turbolandings = get_all_sql(PPC(shard => $shard), 
            ['SELECT tl_id, metrika_counters_json FROM turbolandings', $CLIENT_ID ? (WHERE => {ClientId => $CLIENT_ID}) : ()]);

        $log->out(sprintf('Fetched %s turbolandings', scalar @$turbolandings));
        my $total = 0;
        foreach my $chunk (chunks $turbolandings, $CHUNK_SIZE) {
            fill_tables($shard, $chunk);
            $total += @$chunk;
            sleep 1;
        }

        $log->out("$total turbolandings processed");
        $log->out('FINISH');
    }
    catch {
        $log->out( join "\n", @_);
        die;
    };
});

sub fill_tables {
    my ($shard, $turbolandings) = @_;

    my (@counters, @goals);
    foreach my $tl (@$turbolandings){
        my $counters_with_goals = from_json($tl->{metrika_counters_json} // []);
        next unless @$counters_with_goals;
        push @counters, (map {[$tl->{tl_id}, $_->{isUserCounter} ? 1 : 0, $_->{id}]} @$counters_with_goals);
        push @goals, (map {[$tl->{tl_id}, 0, $_]} map {@$_} map {$_->{goals} // []} @$counters_with_goals);
    }
    do_mass_insert_sql(PPC(shard => $shard),
            'INSERT IGNORE INTO turbolanding_metrika_counters (tl_id, is_user_counter, counter) VALUES %s',
            \@counters) if @counters;

    do_mass_insert_sql(PPC(shard => $shard),
            'INSERT IGNORE INTO turbolanding_metrika_goals (tl_id, is_conversion_goal, goal_id) VALUES %s',
            \@goals) if @goals;
}

$log->out('FINISH');
