#!/usr/bin/perl

use my_inc "../..";


=head1 DESCRIPTION

    Скрипт проставляет уешным клиентам в нашей базе страны, которые выбраны у соответствующих клиентов в Балансе

=cut

use strict;
use warnings;

use Settings;
use Yandex::DBTools;
use ScriptHelper;

local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

use Yandex::Balance;
use Yandex::Retry;

use utf8;

my $CLIENT_UPDATE_CHUNK_SIZE = 1_000;

$log->out('START');

$log->out('Fetching clients');
my $clients = get_all_sql(PPC, 'SELECT ClientID, country_region_id FROM clients WHERE IFNULL(work_currency, "YND_FIXED") = "YND_FIXED"') || [];
$log->out('Got ' . scalar(@$clients) . ' clients to check');

$log->out('Checking client countries');
my @clients_to_update;
my $total_rows_cnt = 0;
for my $client (@$clients) {
    my $client_id = $client->{ClientID};
    $log->out("Checking client $client_id: ", $client);
    my $balance_clients = eval { retry tries => 5, pauses => [1, 3, 9, 27, 81], sub {
        balance_find_client({ClientID => $client_id})
    }};
    if ($balance_clients && @$balance_clients) {
        my $balance_country = $balance_clients->[0]->{REGION_ID} || 0;
        my $our_country = $client->{country_region_id} || 0;
        if ($balance_country != $our_country) {
            $client->{new_country_region_id} = $balance_country;
            push @clients_to_update, $client;
            $log->out("Adding ClientID $client_id to update queue: ", $client);
            if (@clients_to_update >= $CLIENT_UPDATE_CHUNK_SIZE) {
                $total_rows_cnt += update_clients(\@clients_to_update);
                @clients_to_update = ();
            }
        }
    } else {
        $log->out("Error checking ClientID $client_id country in balance: $@. Got result: ", $balance_clients);
    }
}
if (@clients_to_update > 0) {
    $total_rows_cnt += update_clients(\@clients_to_update);
    @clients_to_update = ();
}

$log->out("Total $total_rows_cnt rows changed");

$log->out('FINISH');

=head2 update_clients

    $clients_to_update = [
        {
            ClientID => $client_id,
            new_country_region_id => $new_country_region_id,
            country_region_id => $old_country_region_id,
        },
        ...
    ];
    $rows_affected_cnt = update_clients($clients_to_update);

=cut

sub update_clients {
    my ($clients_to_update) = @_;

    $log->out('Updating ' . scalar(@$clients_to_update) . ' clients:');
    my (@clientids, %clientid2newcountry, %clientid2oldcountry);
    for my $client (@$clients_to_update) {
        $log->out($client);
        my $client_id = $client->{ClientID};
        push @clientids, $client_id;
        $clientid2newcountry{$client_id} = $client->{new_country_region_id};
        $clientid2oldcountry{$client_id} = $client->{country_region_id};
    }
    my $newcountry_case = sql_case('ClientID', \%clientid2newcountry, default__dont_quote => 'country_region_id');
    my $oldcountry_case = sql_case('ClientID', \%clientid2oldcountry);
    my $rows_affected = do_sql(PPC, [
        'UPDATE clients',
        'SET country_region_id =', $newcountry_case,
        'WHERE',
            'IFNULL(work_currency, "YND_FIXED") = "YND_FIXED"',
            'AND', {ClientID => \@clientids},
            'AND country_region_id =', $oldcountry_case,
    ]);

    return $rows_affected;
}
