#!/usr/bin/perl

=head1 NAME

fix-non-agency-in-campaigns-agencyid - Исправляет ошибки в заполнении AgencyID/AgencyUID в кампании

=head1 SYNOPSIS

    ./fix-non-agency-in-campaigns-agencyid.pl [--fix]

=head1 DESCRIPTION

    Находит кампании с проблемами в AgencyID/AgencyUID и чинит их:
    - AgencyUID ссылается на несуществующего пользователя - очищает это поле
    - AgencyUID и AgencyID не соответствуют друг другу - исправляет AgencyID
    - AgencyUID ссылается не на агентство - очищает и AgencyID, и AgencyUID

=cut
use my_inc "../../";
use Direct::Modern;

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use RBAC2::Extended;
use RBACElementary;
use RBACDirect;
use PrimitivesIds;

my $REAL_RUN;
extract_script_params(
    'fix'         => \$REAL_RUN,
);

$log->out('Start');

my $rbac = RBAC2::Extended->get_singleton(1);
my $agency_uids = rbac_get_all_agencies($rbac);
my $campaigns_with_bad_agencyid = get_all_sql(
    PPC(shard => 'all'),
    [
        "select * from campaigns", where => [AgencyUID__gt => 0, AgencyID__gt => 0, AgencyID__not_in => get_clientids(uid => $agency_uids)],
        "union",
        "select * from campaigns where (AgencyUID is null or AgencyUID = 0) and AgencyID is not null and AgencyID > 0",
        "union",
        "select * from campaigns", where => [AgencyUID__gt => 0, AgencyUID__not_in => $agency_uids]
    ]
);

for my $camp (@$campaigns_with_bad_agencyid) {
    my $agency_uid = $camp->{AgencyUID};
    my $db_agency_id = $camp->{AgencyID};
    my $correct_agency_id = get_clientid(uid => $agency_uid);
    if (!$agency_uid) {
        $log->out("cid $camp->{cid} has AgencyID $db_agency_id without AgencyUID, clearing AgencyID/AgencyUID");
        do_update_table(PPC(cid => $camp->{cid}), 'campaigns',
                        {AgencyID => 0, AgencyUID => undef},
                        where => {cid => $camp->{cid}})
            if $REAL_RUN;
    } elsif ('agency' ne rbac_who_is($rbac, $agency_uid)) {
        $log->out("cid $camp->{cid} has AgencyUID $agency_uid which is not an agency, clearing AgencyID/AgencyUID");
        do_update_table(PPC(cid => $camp->{cid}), 'campaigns',
                        {AgencyID => 0, AgencyUID => undef},
                        where => {cid => $camp->{cid}})
            if $REAL_RUN;
    } elsif ($correct_agency_id) {
        $log->out("cid $camp->{cid}: has AgencyID $db_agency_id, correct is $correct_agency_id for AgencyUID $agency_uid, updating AgencyID");
        do_update_table(PPC(cid => $camp->{cid}), 'campaigns',
                        {AgencyID => $correct_agency_id, AgencyUID => $agency_uid},
                        where => {cid => $camp->{cid}})
            if $REAL_RUN;
    } else {
        $log->out("Unknown case for cid $camp->{cid}");
    }
}

$log->out('Finish');
