#!/usr/bin/perl

=head1 NAME

    fix_bs_auction_stat_negative_values.pl

=head1 DESCRIPTION

    Скрипт проверяет таблицу bs_auction_stat на предмет отрицательных показов и кликов. Найденные значения зануляет.

=cut

use strict;
use warnings;

use my_inc '../..';

use lib::abs '..';
use ScriptHelper;
use Settings;
use ShardingTools;

use Yandex::DBTools;

$log->out('START');

foreach my $shard (ppc_shards()) {
    $log->msg_prefix("shard $shard");
    $log->out('Fetching incorrect data from bs_auction_stat');
    my $incorrect_data = get_all_sql(PPC(shard => $shard),
        "SELECT pid, PhraseID, shows, clicks FROM bs_auction_stat WHERE shows < 0 OR clicks < 0"
    ) || [];
    $log->out($incorrect_data);
    foreach my $row (@$incorrect_data) {
        my $res = do_sql(PPC(shard => $shard),
            "UPDATE bs_auction_stat
                SET shows = IF(shows < 0, 0, shows)
                  , clicks = IF(clicks < 0, 0, clicks)
              WHERE pid = $row->{pid}
                    AND PhraseID = $row->{PhraseID}"
        );
        $log->out("Updated shows and clicks for pid: $row->{pid}, PhraseID: $row->{PhraseID} - affected $res lines");
    }
}

$log->out('FINISH');
