#!/usr/bin/env perl

use my_inc "../..";

=head1 DESCRIPTION

=cut

use Direct::Modern;
use open ':std' => ':utf8';

use Settings;
use ScriptHelper;
use Models::CampaignOperations;

use Yandex::DBTools;
use ShardingTools;

$log->out('START');

    for my $shard (ppc_shards()) {
        my $rows = get_all_sql(PPC(shard => $shard), ["select c.cid from campaigns c  
                                                        where c.statusModerate='Ready' and archived='No' 
                                                            and  (select count(*) from banners b join phrases p using(pid)  
                                                                    where b.cid=c.cid and b.statusModerate in ('Ready', 'Sending') 
                                                                        and p.statusModerate in ('Ready', 'Sending')) = 0"]);

        my @cids = map { $_->{cid} } @$rows;
        
        $log->out("Processing", \@cids);

        do_update_table(PPC(shard => $shard), 'campaigns', {statusModerate => 'Sent'}, where => {cid=> \@cids, statusModerate => 'Ready'});

        for my $cid (@cids) {
            Models::CampaignOperations::db_update_campaign_statusModerate($cid);
        }

    }

$log->out('FINISH');

1;
