#!/usr/bin/perl

use my_inc "../..";

use strict;
use warnings;

use Settings;

use ScriptHelper;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry;

our $CHUNK_SIZE = 100;

# --------------------------------------------------------------------
sub main {
    $log->out('start');

    my $pids = get_one_column_sql(PPC(shard => 'all'),
        "select pid
         from phrases
         where statusShowsForecast = ''
        "
    ) || [];

    foreach_shard pid => $pids, chunk_size => $CHUNK_SIZE, sub {
        my ($shard, $pids_chunk) = @_;

        relaxed times => 1, sub {
            my $updated = do_update_table(PPC(shard => $shard)
                                          , 'phrases'
                                          , {statusShowsForecast => 'New'}
                                          , where => {pid => $pids_chunk
                                                      , statusShowsForecast => ''
                                                     }
                                         );
            $log->out({pids => $pids_chunk, updated => $updated});
        };
    };

    $log->out('finish');
}

# --------------------------------------------------------------------
main();
