#!/usr/bin/perl

=head2 NAME

    fix_image_ad-status-moderate.pl

=head2 SYNOPSYS

    /var/www/ppc.yandex.ru/protected/one-shot/fix_image_ad-status-moderate.pl

=head2 DESCRIPTION

    Поправляем значение поля images.statusModerate для случая если
    images.statusModerate = "New" и
    banners.statusModerate = "Yes"

=cut

use Direct::Modern;

use my_inc '../..';

use BS::ResyncQueue;
use Settings;
use ScriptHelper;
use ShardingTools;

use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::Retry qw/relaxed/;

my $SLEEP_COEF = 0.5;
my $DRY_RUN = 0;
my $BS_RESYNC_PRIORITY = BS::ResyncQueue::PRIORITY_ONE_SHOT_FIX_MODERATION_FLAGS;
extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
    'dry-run' => \$DRY_RUN,
    'bs-resync-priority' => \$BS_RESYNC_PRIORITY,
);

$log->out('START');

$log->out( { launch_parameters => { SLEEP_COEF => $SLEEP_COEF, DRY_RUN => $DRY_RUN, BS_RESYNC_PRIORITY => $BS_RESYNC_PRIORITY } } );

for my $shard (ppc_shards()) {
    my $prefix_guard = $log->msg_prefix_guard("[shard=$shard]");
    $log->out("selecting problematic images");
    my $rows = get_all_sql(PPC(shard => $shard),
        "SELECT c.cid, b.bid, i.image_id FROM images i
          INNER JOIN banners b ON i.bid = b.bid INNER JOIN campaigns c ON b.cid = c.cid
          WHERE b.banner_type='image_ad' AND i.statusModerate='New' AND b.statusModerate='Yes'"
    );
    $log->out(sprintf("got %s images", scalar(@$rows)));

    my @chunks = chunks($rows, 1_000);
    for my $chunk_idx ( 0 .. $#chunks ) {
        my $chunk = $chunks[$chunk_idx];
        my $prefix_guard = $log->msg_prefix_guard("[shard=$shard, chunk_idx=$chunk_idx, chunk_cnt=" . scalar(@chunks) . "]");
        relaxed times => $SLEEP_COEF, sub {
            $log->out( { chunk => $chunk } );

            my @resync_data = map { { cid => $_->{cid}, pid => 0, bid => $_->{bid}, priority => $BS_RESYNC_PRIORITY } } @$chunk;
            $log->out( { resync_data => \@resync_data } );

            if ($DRY_RUN) {
                $log->out("not actually updating or sending to BS because it is a dry run");
                return;
            }

            $log->out('updating images');
            my $updated_rows = do_sql( PPC(shard => $shard), [
                'UPDATE images INNER JOIN banners USING(bid) SET images.statusModerate="Yes"',
                WHERE => {
                    'images.image_id' => [ map { $_->{image_id} } @$chunk ],
                    'images.statusModerate' => 'New',
                    'banners.statusModerate' => 'Yes',
                },
            ] );
            $log->out( { updated_rows => $updated_rows } );

            my $rows_affected_by_resync = bs_resync(\@resync_data);
            $log->out( { rows_affected_by_resync => $rows_affected_by_resync } );
        };
    }
}

$log->out('FINISH');
