#!/usr/bin/perl

use my_inc "../..";


=head1 NAME


=head1 DESCRIPTION

Для видео и ГО креативов с live_preview_url == null, устанавливает live_preview_url = preview_url

=cut

use strict;

use warnings;

use Yandex::Retry qw/relaxed/;
use Yandex::DBTools;
use Settings;
use ShardingTools;
use ScriptHelper;


my $testVersion;
my $client_id;
if (@ARGV == 1 ) {
    $testVersion = 1;
    $client_id = $ARGV[0];
}else {
    $testVersion = 0;
}

my $chunk = ($client_id ?  10_000_000_000: 100_000);

my $creatives_fixed = 0;

$log->out('START');
for my $shard (ppc_shards()) {
    my ($min, $max) = get_one_line_array_sql(PPC(shard => $shard),
        "select min(creative_id), max(creative_id) from perf_creatives");
    my %to_update;
    while ($min < $max) {
        $log->out("$min/$max");
        my $rows = get_all_sql(PPC(shard => $shard), [
                "select creative_id, preview_url, live_preview_url from perf_creatives",
                where => {
                    creative_id__between      => [ $min, $min + $chunk - 1 ],
                    live_preview_url__is_null => 1,
                    creative_type__in         => [ 'video_addition', 'canvas' ],
                    ($client_id ? (ClientID => $client_id) : ()),
                },
            ]);
        for my $creative (@$rows) {
            my $cur_preview_url = $creative->{preview_url};
            my $cur_live_preview_url = $creative->{live_preview_url};
            if (defined $cur_live_preview_url) {
                # $log->out("valid live_preview_url (should not be there)");
                next;
            }
            $to_update{$creative->{creative_id}} = $cur_preview_url;
        }
        if (keys %to_update > 1000) {
            relaxed times => 2, sub {
                    $creatives_fixed += int do_update_table(PPC(shard => $shard), 'perf_creatives',
                            { live_preview_url__dont_quote =>
                                sql_case(creative_id => \%to_update) },
                            where => {
                                creative_id => [ keys %to_update ]
                            }
                        );
                };
            %to_update = ();
        }
    }
        continue {
            $min += $chunk;
        }
    if (keys %to_update > 0) {
        relaxed times => 2, sub {
                $creatives_fixed += int do_update_table(PPC(shard => $shard), 'perf_creatives',
                        { live_preview_url__dont_quote =>
                            sql_case(creative_id => \%to_update) },
                        where => {
                            creative_id => [ keys %to_update ]
                        }
                    );
            };
    }
}

$log->out("$creatives_fixed creatives fixed");
$log->out('FINISH');
