#!/usr/bin/perl

use my_inc "../..";

=head1 DESCRIPTION

    Отправляет зависшие сайтлинки на модерацию.
    Возможно, нужно будет запустить несколько раз с интервалом в ~3-5 часов (чтобы на модерацию не пришло все разом).

    LOG_TEE=1 ./protected/one-shot/fix_sitelinks_status_moderate.pl

    Параметры:

        only-shards   -- список шардов, на которых запускать (через запятую)
        chunk-size    -- сколько баннеров обрабатывать за раз (1000 по умолчанию)
        dry-run       -- запуск без внесения изменений в БД

    Скрипт работает параллельно с каждым шардом. Можно перезапускать.

=cut

use Direct::Modern;
use open ':std' => ':utf8';

use Settings;
use ScriptHelper;

use Yandex::DBTools;
use Yandex::DBShards;
use ShardingTools qw/ppc_shards/;
use POSIX qw/ceil/;

my ($ONLY_SHARDS, $CHUNK_SIZE, $DRY_RUN);
extract_script_params(
    'only-shards:s' => \$ONLY_SHARDS,
    'chunk-size:i'  => \$CHUNK_SIZE,
    'dry-run'       => \$DRY_RUN,
);

$CHUNK_SIZE ||= 1000;

# На сколько частей делить поиск по баннерам
my $PARTS_QTY = 20;

$log->out('START');

my @shards = defined $ONLY_SHARDS ? grep { /^\d+$/ } (split /,/, $ONLY_SHARDS) : ppc_shards();
die "No valid shards specified" unless @shards;
$log->out("Running on shards: ".join(',', @shards));

my $script_name = get_script_name();
my $shard_results = foreach_shard_parallel(shard => \@shards, sub {
    my ($shard) = @_;

    my $log_shard = Yandex::Log->new(
        log_file_name => $script_name.".shard_${shard}.log",
        date_suf      => '%Y%m%d',
        msg_prefix    => "[shard:$shard]",
    );
    $log_shard->out('START');

    eval {
        my $found = 0;

        my ($min_bid, $max_bid) = get_one_line_array_sql(PPC(shard => $shard), q{SELECT min(bid), max(bid) FROM banners});
        my $step = ceil(($max_bid - $min_bid + 1) / $PARTS_QTY);
        my $iter_num = 1;
        for (my $start = $min_bid; $start <= $max_bid; $start += $step, $iter_num++) {
            my $end = $start + $step - 1;
               $end = $max_bid if $end > $max_bid;

            $log_shard->out("Processing banners with bids between $start and $end ($iter_num/$PARTS_QTY)");
            my $bids = get_one_column_sql(PPC(shard => $shard),
                q{SELECT bid FROM banners WHERE bid >= ? AND bid <= ? AND IFNULL(sitelinks_set_id, 0) != 0 AND statusSitelinksModerate = 'New' AND statusModerate != 'New' LIMIT ?},
                $start, $end, $CHUNK_SIZE - $found,
            );
            $found += scalar @$bids;

            $log_shard->out("Found: ".scalar(@$bids)." banners");
            $log_shard->out("bids: ".join(',', @$bids)) if @$bids;

            if (!$DRY_RUN && @$bids) {
                my $quantity = do_update_table(PPC(shard => $shard), 'banners', {statusSitelinksModerate => 'Ready'},
                    where => {
                        bid => $bids,
                        sitelinks_set_id__is_not_null => 1,
                        sitelinks_set_id__gt => 0,
                        statusSitelinksModerate => 'New',
                        statusModerate__ne => 'New',
                    },
                );
                $log_shard->out("Updated: $quantity banners");
            }

            last if $found == $CHUNK_SIZE;
        }

        $log_shard->out("Perhaps still available banners. Please restart script for the shard.") if $found == $CHUNK_SIZE;

        1;
    } or do {
        $log_shard->out("Error: $@");
    };

    $log_shard->out('FINISH');
});
$log->out("Per-shard results:", $shard_results);

$log->out('FINISH');
