#!/usr/bin/perl


=head1 NAME


=head1 DESCRIPTION

Скрипт визитке с указанымм id указанный телефон и перепосылает
все затронутые баннеры в БК через очередь ленивой переотправки.

=cut

use open ':std', ':encoding(UTF-8)';

use my_inc '../..';
use Direct::Modern;
use Direct::Validation::VCards qw//;

use BS::ResyncQueue qw//;
use ScriptHelper;
use Settings;
use Yandex::DBTools qw/do_update_table get_one_column_sql get_one_line_sql/;

my $DRYRUN   = 0;
my $PRIORITY = $BS::ResyncQueue::PRIORITY_MAINTENANCE_FIX_VCARD_GEO_ID;
my $VCARD_ID;
my $PHONE;

$log->out('START');

extract_script_params(
    'dry'        => \$DRYRUN,
    'priority:i' => \$PRIORITY,
    'vcard_id=i' => \$VCARD_ID,
    'phone=s'    => \$PHONE,
);

# check vcard id
unless ($VCARD_ID) {
    $log->die("No vcard id given!\n");
}

if ( ! defined $PHONE ) {
    $log->die("No phone given!\n");
}

my $vresults = Direct::Validation::VCards::validate_vcard_phone($PHONE);
if ( defined $vresults ) {
    $vresults->process_descriptions(__global => {field => 'PHONE'});
    $log->die(join("\n\t" => @{ $vresults->get_error_descriptions }));
}

my $vcard = get_one_line_sql(PPC(vcard_id => $VCARD_ID), [
    'select vcard_id, phone from vcards',
    where => { vcard_id => $VCARD_ID }
]);

unless ($vcard) {
    $log->die("Vcard #$VCARD_ID not found");
}

# gather bids
my $bids = get_one_column_sql(PPC(vcard_id => $VCARD_ID), [
    'select bid from banners',
    where => {
        vcard_id      => $VCARD_ID,
        phoneflag__ne => 'New',
    }
]);

my $banners_cnt = scalar(@$bids);

$log->out(''. $banners_cnt .' banners found with vcard with id #'. $VCARD_ID);

# update vcard's phone
if (!$DRYRUN) {
    my $rows_updated = do_update_table(PPC(vcard_id => $VCARD_ID),
        vcards => {
            phone                  => $PHONE,
            LastChange__dont_quote => 'LastChange',
        },
        where => {
            vcard_id => $VCARD_ID,
            phone    => $vcard->{phone},
        }
    );
}

$log->out('Phone for vcard with id #'. $VCARD_ID .' changed from '. $vcard->{phone} .' to '. $PHONE);

# resend banners to BS
if (!$DRYRUN) {
    my $rows_updated = do_update_table(PPC(bid => $bids),
        banners => {
            phoneflag => 'Ready',
        },
        where => {
            bid      => $bids,
            vcard_id => $VCARD_ID,
        }
    );

    if ($rows_updated != $banners_cnt) {
        $log->out('NB: only '. $rows_updated .' banners marked for resending to moderation instead of '. $banners_cnt .'!');
    }
}

$log->out('Banners was marked for resending to moderation, bids: '. join(', ' => @$bids));

$log->out('FINISH');
