#!/usr/bin/perl

use my_inc "../..";


=head1 NAME


=head1 DESCRIPTION

Скрипт приводит в соответствие поля geo_id и city в vcards

Предполагается, что city верный, а geo_id требует обновления

=cut

use strict;
use warnings;

use lib::abs '..';

use Yandex::Retry qw/relaxed/;
use Yandex::DBTools;
use Settings;
use GeoTools qw/get_geoid_by_cityname/;
use ShardingTools;
use BS::ResyncQueue;
use ScriptHelper;

my $chunk = 100_000;

my ($vcards_fixed, $banners_resended) = (0, 0);

$log->out('START');
for my $shard (ppc_shards()) {
    my $rg = $log->msg_prefix_guard("[shard $shard]");
    my ($min, $max) = get_one_line_array_sql(PPC(shard => $shard), "select min(vcard_id), max(vcard_id) from vcards");
    my @resend;
    while ($min < $max) {
        $log->out("$min/$max");
        my $rows = get_all_sql(PPC(shard => $shard), [
            "select vcard_id, city, geo_id from vcards",
            where => {
                vcard_id__between => [ $min, $min + $chunk - 1],
            },
        ]);
        for my $row (@$rows) {
            my $cur_geo_id = $row->{geo_id};
            my $new_geo_id = GeoTools::get_geoid_by_cityname($row->{city});
            if ($new_geo_id == 0) {
                # $log->out("failed to get new geo id for $row->{city}");
                next;
            }
            if ($new_geo_id != $cur_geo_id) {
                $log->out({ %$row, new_geo_id => $new_geo_id });
                relaxed times => 2, sub {
                    $vcards_fixed += int do_update_table(PPC(shard => $shard), 'vcards', { geo_id => $new_geo_id },
                        where => {
                            vcard_id => $row->{vcard_id},
                            geo_id => $cur_geo_id,
                            city => $row->{city},
                        },
                    );
                };
                push @resend, $row->{vcard_id};
            }
        }
        if (@resend > 1000) {
            relaxed times => 2, sub {
                my $priority = BS::ResyncQueue::PRIORITY_MAINTENANCE_FIX_VCARD_GEO_ID;
                my $resync = get_all_sql(PPC(shard => $shard), [
                    "select cid, bid, 0 as pid, $priority as priority from banners", where => { vcard_id => \@resend }
                ]);
                $log->out((scalar @$resync). " banners to resync");
                bs_resync($resync);
                $banners_resended += scalar @$resync;
            };
            @resend = ();
        }
    } continue {
        $min += $chunk;
    }
    if (@resend) {
        relaxed times => 2, sub {
            my $priority = BS::ResyncQueue::PRIORITY_MAINTENANCE_FIX_VCARD_GEO_ID;
            my $resync = get_all_sql(PPC(shard => $shard), [
                "select cid, bid, 0 as pid, $priority as priority from banners", where => { vcard_id => \@resend }
            ]);
            $log->out((scalar @$resync). " banners to resync");
            bs_resync($resync);
            $banners_resended += scalar @$resync;
        };
    }
}

$log->out("$vcards_fixed vcards fixed, $banners_resended banners resended");

$log->out('FINISH');
