#!/usr/bin/perl

use my_inc "../..";


=head2 NAME

    fix_wallet_for_currency_converted_campaigns.pl

=head2 SYNOPSYS

    /var/www/ppc.yandex.ru/protected/one-shot/fix_wallet_for_currency_converted_campaigns.pl --uid=NNNNNN --wallet-cid=ZZZZZ

=head2 DESCRIPTION

    Скрипт для отключения валютных кампаний от фишечного общего счета.

    Полезен для клиентов, которые вместе с кошельком сконвертировались в валюту копированием.
    ДЕНЬГИ С КОШЕЛЬКА НЕ ПЕРЕНОСИТ, это требуется делать вручную, через биллинг.

    Устанавливает wallet_cid = 0 и statusBsSynced на все кампании, удовлетворяющие всем перечисленным условиям:
        * uid из параметров
        * wallet_cid из параметров
        * совпадает AgencyID на кампании и общем счете
        * валюта кампании отличается от YND_FIXED
    А также переотправляет их в биллинг.

=cut

use strict;
use warnings;

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use RBAC2::Extended;
use Campaign;
use Yandex::Validate;

use utf8;

my $uid;
my $ynd_fixed_wallet_cid;

extract_script_params(
    'uid=i' => \$uid,
    'wallet-cid=i' => \$ynd_fixed_wallet_cid,
);
die 'valid uid and wallet_cid should be specified' unless is_valid_id($uid) && is_valid_id($ynd_fixed_wallet_cid);

$log->out('START');
$log->out("Processing uid = $uid, wallet_cid = $ynd_fixed_wallet_cid");


my $rbac = eval { RBAC2::Extended->get_singleton(1) }
    or $log->die("Can't connect to RBAC: $@");

# Выбираем информацию про кошелек.
my $wallet_info = get_one_line_sql(PPC(uid => $uid), [
    'SELECT cid, AgencyID FROM campaigns',
    WHERE => {
        uid => $uid,
        cid => $ynd_fixed_wallet_cid,
        type => 'wallet',
        _TEXT => "IFNULL(currency, 'YND_FIXED') = 'YND_FIXED'"
    }
]);
$log->out({wallet_info => $wallet_info});
unless ($wallet_info && ref $wallet_info eq 'HASH' && $wallet_info->{cid}) {
    $log->die('Invalid wallet campaign');    
}


# Выбираем кампании, на которых будем менять номер кампании кошелька
my $camps_to_remove_wallet = get_one_column_sql(PPC(uid => $uid), [
    "SELECT cid FROM campaigns",
    WHERE => {
        uid => $uid,
        AgencyID => $wallet_info->{AgencyID},
        wallet_cid => $ynd_fixed_wallet_cid,
        type => 'text',
        _TEXT => "IFNULL(currency, 'YND_FIXED') <> 'YND_FIXED'",
    }
] ) || [];
$log->out({camps_for_remove_wallet_cid => $camps_to_remove_wallet});


# отцепляем кампании от кошелька и переотправляем их в БК.
my $rez = do_update_table(PPC(uid => $uid), 'campaigns',
    {
        wallet_cid => 0,
        statusBsSynced => 'No',
    },
    where => {
        uid => $uid,
        cid => $camps_to_remove_wallet,
        AgencyID => $wallet_info->{AgencyID},
        wallet_cid => $ynd_fixed_wallet_cid,
        type => 'text',
        _TEXT => "IFNULL(currency, 'YND_FIXED') <> 'YND_FIXED'",
    }
);
$log->out("Updated $rez campaigns, set wallet_cid = 0, statusBsSynced = No");

# отправляем изменения в баланс
$log->out("Sending campaigns to balance");
my $create_campaigns_balance_res;
eval {
    ($create_campaigns_balance_res) = create_campaigns_balance($rbac, 1, $camps_to_remove_wallet)->{balance_res};
};
$log->out({result_data => $create_campaigns_balance_res});
if ($@ || !$create_campaigns_balance_res) {
    $log->out("Error: $@");
}

$log->out('FINISH');

