#!/usr/bin/perl

=head1 NAME

    fix_wrong_group_draft.pl

=head1 DESCRIPTION

    Устраняет последствия не корректного сохранения состояния "черновик" у группы объявлений.
    Для исправления отправляем группы объявлений(только условия показа - фразы/ретаргетинг) на модерацию.
    
    Можно запускать с параметром --sleep-coeff для пауз между итерациями
    
=cut

use strict;
use warnings;
use utf8;

use my_inc '../..';

use lib::abs '../../protected';
use Settings;
use Yandex::DBTools;
use ScriptHelper;
use ShardingTools;
use Yandex::ListUtils qw/chunks/;
use Yandex::Retry qw/relaxed/;

my $sleep_coeff = 1;
extract_script_params(
    'sleep-coeff=i' => \$sleep_coeff
);
$sleep_coeff = 1 unless defined $sleep_coeff;

$log->out('start');
foreach my $shard (ppc_shards()) {
    $log->msg_prefix("shard_$shard ");
    $log->out('Fetching pids to fix');
    my $pids = get_next_pids($shard);
    if (@$pids) {
        $log->out("got " . scalar(@$pids) . " groups");
        relaxed times => $sleep_coeff, sub {
            send_to_moderate($shard => $pids)
        };
    } else {
        $log->out('No pids to fix found');
    }
}
$log->out('finish'); 

sub get_next_pids {
    my $shard = shift;
    return get_one_column_sql(PPC(shard => $shard), "
        SELECT p.pid
        FROM phrases p
        INNER JOIN banners b ON p.pid = b.pid
        WHERE
            p.statusModerate = 'New'
            AND b.statusModerate != 'New'
            AND (p.PriorityID > 0 OR p.ContextID > 0)
    ") || [];
}

sub send_to_moderate {
    my ($shard, $pids) = @_;
    
    foreach my $ids (chunks $pids, 1000) {
        $log->out("send to moderate pids: " . join ",", @$ids);
        my $affected = do_sql(PPC(shard => $shard), [
            "UPDATE phrases SET statusModerate = 'Ready', LastChange = LastChange",
            WHERE => {pid => $ids, statusModerate => 'New', _OR => {PriorityID__gt => 0, ContextID__gt => 0}}
        ]);
        $log->out("affected rows " . ($affected + 0));
    }
}

