#!/usr/bin/perl

=pod

=encoding utf8

    $Id:$

=head1 NAME

    flush_test_mds_reports.pl

=head1 SYNOPSIS

    LOG_TEE=1 ./protected/one-shot/flush_test_mds_reports.pl --shard-id 1

=head1 DESCRIPTION

    На тестовых средах мы создаем файлы с TTL, чтобы не забить тестовый MDS.
    На тестовых средах имя файла -- хэш от его контента, чтобы незабить маленький тестовый MDS гоняя на нем тесты. 

    Итог: файлы со временем протухают, залить такой файл заного нельзя, а мы
    пытаемся, т.к. контент в статистическом файле один и тот же между запусками теста

    Подробности: https://st.yandex-team.ru/DIRECT-60437
    Ручное решение: https://wiki.yandex-team.ru/direct/api/duty/commonproblems/#izmdsnevozvrashhaetsjaotchet404ilivozvrashhaetsjapustojjfajjl

    Скрипт является автоматизацией ручного решения. Получает из БД отчеты и
    явно удаляет в MDS те, которые там не найдены (не найдены они могут быть
    как потому что их там не было никогда так и потому что у них вышел срок жизни)

=head1 METHODS

=cut

use my_inc "../..";

use Direct::Modern;

use Yandex::HTTP;

use EnvTools;
use ScriptHelper sharded => 1;
use Settings;
use Yandex::DBTools;

my $MDS_URL_PREFIX = 'http://storage-int.mdst.yandex.net';
my $MDS_CHECK_URL = "$MDS_URL_PREFIX/get-direct-files/";
my $MDS_DELETE_URL = "$MDS_URL_PREFIX:1111/delete-direct-files/";

my $MDS_DELETE_TOKEN = "ZGlyZWN0LWZpbGVzOjYxMDYxZWU4YmEyM2IzZjI1ZDgwOTJhN2I5MzMwMTk1";

die "not for production now" if is_production();

$log->out('START');

my $mds_keys = get_hash_sql(PPC(shard => $SHARD), 'select
    mds_key,mcn.filename
    from mds_custom_names mcn
        join mds_metadata mm on (mcn.mds_id=mm.id)
    where mcn.filename LIKE "%report_%"');

foreach my $mds_key (keys %$mds_keys) {
    my $filename = $mds_keys->{$mds_key};
    next unless $mds_key =~ m!/report_(dynamic|performance)!;
    next unless $filename =~ /\.tsv/;
    if (mds_file_not_found($mds_key)) {
        $log->out("$mds_key (filename: $filename) doesn't exists in mds, deleting..");
        mds_file_delete($mds_key);
        $log->out("..success");
    } else {
        $log->out("$mds_key ok, skipping");
    }
}

$log->out('FINISH');

=head2 mds_file_not_found($mds_key)

    Возвращает true если файл по указанному ключу не найден в mds, что может
    значит что его там никогда не было, либо у него просрочено TTL

=cut

sub mds_file_not_found {
    my $mds_key = shift;
    my $response = submit_form('GET', $MDS_CHECK_URL . $mds_key, undef);
    if ($response->code eq 404) {
        return 1;
    }
    return;
}

=head2 mds_file_delete($mds_key)

    Удаляем файл в тестовом MDS, по указанному ключу

=cut

sub mds_file_delete {
    my $mds_key = shift;
    my $response = submit_form('GET', $MDS_DELETE_URL . $mds_key, undef,
        headers => {
            Authorization => "Basic $MDS_DELETE_TOKEN"
        }
    );

    if (!$response->is_success) {
        $log->out("$mds_key delete failed: $0 response-code: " . $response->code);
    }

    return;
}
