#!/usr/bin/perl

use my_inc '../..';

=head1 DESCRIPTION

    Формирование файла с группами объявлений, которые имеют фразы с не корретным состоянием модерации.
    Файл пригоден для массовой переотправки таких групп в модерацию через https://direct.yandex.ru/registered/main.pl?cmd=importIntoModerationResyncQueue
    
    Файлы будут созданы в корне рабочей копии adgroups_moderate_${shard}.txt

=cut

use Direct::Modern;
use Yandex::DBTools;
use Yandex::DBShards;

use Settings;
use ScriptHelper;
use ShardingTools;

use constant CAMP_LIMIT => 70_000;

$log->out('START');

foreach_shard_parallel shard => [ppc_shards()], sub {
    my ($shard) = @_;
    
    $log->msg_prefix("[shard $shard]");
    my ($min_cid, $max_cid) = get_one_line_array_sql(PPC(shard => $shard), "SELECT MIN(cid), MAX(cid) FROM campaigns WHERE statusModerate = 'Yes' AND type = 'text'");
    $log->out(sprintf 'process campaigns cid %d..%d', $min_cid, $max_cid);
    
    open MODERATE_PIDS, '>', "${Settings::ROOT}/adgroups_moderate_${shard}.txt";
    while($min_cid <= $max_cid) {
        my $pids = get_one_column_sql(
            PPC(shard => $shard),  
            "SELECT DISTINCT p.pid
            FROM phrases p JOIN bids bi using(pid)
            WHERE p.cid BETWEEN ? AND ? AND p.statusModerate IN ('Yes', 'No') AND bi.statusModerate = 'New'",
            $min_cid, $min_cid + CAMP_LIMIT);
        $log->out(sprintf 'processed campaigns cid %d..%d max cid - %d', $min_cid, $min_cid + CAMP_LIMIT, $max_cid);
        $min_cid += CAMP_LIMIT + 1; 
                
        printf MODERATE_PIDS join("\n", map {"phrases $_"} @$pids) . "\n" if @$pids;
    }
    close MODERATE_PIDS;
};

$log->out('FINISH');






