#!/usr/bin/perl
use Direct::Modern;

use Try::Tiny;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;

use my_inc '../..';
# для выполнения на проде переключиться на конфигурацию conf-roprod
use Settings;
use ScriptHelper 'Yandex::Log' => [ date_suf => '%Y%m%d', auto_rotate => 1, tee => $ENV{LOG_TEE}, lock => 1 ];
use JSON;

extract_script_params();

my $FROM_DATETIME = '2017-07-03 00:00:00';

require Yandex::Clickhouse;
my $instance_config = get_db_config("ppchouse:logs");
my $ch = Yandex::Clickhouse->new(
    host => 'ppchouse.yandex.net',
    user => 'readonly',
    port => '8123',
    timeout => '3600',
    settings => {
        database => $instance_config->{db},
        max_query_size => 966899,
    },
);

$log->out('start');

my $ch_query_deleted = "
        SELECT primary_key
        FROM binlog_rows
        WHERE table = 'banners_performance'
                AND method = 'ads.update'
                AND operation = 'DELETE'
                AND datetime >= toDateTime('$FROM_DATETIME')
        FORMAT JSON
";

$log->out($ch_query_deleted);
my $results = $ch->query($ch_query_deleted);
$log->out("got rows with deleted creative_ids: " . $results->json->{rows});

my $banner_creative_ids = [ map { $_->{primary_key} } @{$results->json->{data}}];

my @bids_creatives;
for my $chunk (chunks $banner_creative_ids, 5000) {
    my $ch_query_inserts = "
            SELECT *
            FROM binlog_rows
            WHERE table = 'banners_performance'
                    AND operation = 'INSERT'
                    AND datetime >= toDateTime('$FROM_DATETIME')
                    AND primary_key IN (" . join(',', map { "'$_'" } @$chunk) . ")
            FORMAT JSON
    ";

    my $inserts_cids_rows = $ch->query($ch_query_inserts);
    $log->out("got rows with inserts to banners_performance: " . $inserts_cids_rows->json->{rows});

    # [ [bid, creative_id] ]
    push @bids_creatives, map { [ $_->{'row.value'}[0], $_->{'row.value'}[3] ] } @{$inserts_cids_rows->json->{data}};
}

say to_json(\@bids_creatives);

$log->out('finish');

