#!/usr/bin/perl

=pod

=encoding utf8

    $Id:$

=head1 NAME

    html5_bperf_status_moderate_yes.pl

=head1 SYNOPSIS

    LOG_TEE=1 ./deploy/20171222_html5_bperf_status_moderate_yes.pl --cid 115770856 --cid 115853866 --cid 114378381 --dry-run

=head1 DESCRIPTION

    https://st.yandex-team.ru/DIRECT-74318

    Код директа для HTML5 пока в бранче. Перед выкладкой надо потестировать
    работу транспорта в БК, это можно сделать с лимтеста. На лимтесте нет
    транспорта в модерацию. Поэтому, создаем на лимтесте html5-креативные
    объявления, модерируем кампанию обычным образом, получаем промодерированные
    объявления и креативы в banners_performance в состоянии Sending, им нужно
    прямо в БД поставить StatusModerate=Yes. Для этого нужна миграция.


    Пример запуска, чтобы посмотреть что произойдет:
    LOG_TEE=1 ./deploy/20171222_html5_bperf_status_moderate_yes.pl --cid 115770856 --cid 115853866 --cid 114378381 --dry-run

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '../..';

use ScriptHelper;
use Settings;

extract_script_params(
    'cid=i' => \my @cids,
    'dry-run' => \my $DRY_RUN,
);

$log->out('START');
$log->out("DRY RUN, NO CHANGES MADE") if $DRY_RUN;
$log->die("cids are mandatory") unless @cids;

foreach_shard cid => \@cids, chunk_size => 1_000, with_undef_shard => 1, sub {
    my ($shard, $cids_chunk) = @_;
    if (!$shard) {
        $log->msg_prefix(undef);
        $log->out({ERROR_cids_without_shard => $cids_chunk});
    } else {
        my $log_prefix_guard = $log->msg_prefix_guard("[shard $shard]");
        $log->out("cids: ", $cids_chunk);

        my $creatives = get_all_sql(PPC(shard => $shard), [
            'SELECT c.cid, bp.banner_creative_id, p_cr.creative_id, bp.statusModerate
                FROM campaigns c
                    JOIN banners_performance bp ON bp.cid = c.cid
                    JOIN banners b ON b.bid = bp.bid
                    JOIN phrases g ON g.pid = b.pid
                    JOIN perf_creatives p_cr ON p_cr.creative_id = bp.creative_id',
                WHERE => {
                    'c.cid' => $cids_chunk,
                    'c.statusEmpty' => 'No',
                    'c.statusModerate' => 'Yes',
                    'b.banner_type' => 'cpm_banner',
                    'b.statusModerate' => 'Yes',
                    'g.statusModerate' => 'Yes',
                    'p_cr.statusModerate' => 'Yes',
                    'p_cr.creative_type' => 'html5_creative',
                    'bp.statusModerate' => 'Sending',
                }]);

        $log->out("found unmoderated html5_creatives: ", $creatives);

        if(@$creatives && !$DRY_RUN) {
            my $bp_ids = [ map { $_->{banner_creative_id} } @$creatives ];
            my $res = do_update_table(PPC(shard => $shard), 'banners_performance', { statusModerate => "Yes" }, where => {banner_creative_id => $bp_ids, statusModerate=>"Sending"});
            $log->out({updated_rows => $res});
        }
    }
};

$log->out('FINISH');
