#!/usr/bin/perl

use Direct::Modern;

use Yandex::HashUtils;
use Yandex::Validate;
use Yandex::YT::Table;

use my_inc '../..';

use BS::ResyncQueue;
use ScriptHelper;
use Settings;
use Tools ();

use constant FLUSH_CHUNK_SIZE => 100_000;

$Yandex::YT::Streaming::DEFAULT_FORMAT = 'json';

my @resync;
sub flush {
    my $last = shift;
    if (@resync >= FLUSH_CHUNK_SIZE || $last) {
        $log->out("add data chunk to bs_resync_queue");
        my $cnt = BS::ResyncQueue::bs_resync(\@resync);
        $log->out("affected $cnt rows");
        @resync = ();
    }
}


my $table_path;
my $priority = 0;
extract_script_params(
    'table=s' => \$table_path,
    'priority=i' => \$priority,
);


unless ($table_path) {
    die "--table parameter is mandatory";
}

unless (is_valid_int($priority, -128,127)) {
    die "--priority must be in [-128,127] range";
}


$log->out("START");

$log->out("setup YT env");
Tools::set_yt_environment();

$log->out("Import data from $table_path with priority $priority");
my $table = Yandex::YT::Table->new($table_path);
unless ($table->exists()) {
    $log->die("table $table_path doesn't exists");
}

$log->out("let's import data");
my $reader = $table->reader();
while(my $r = $reader->next()) {
    my $item = hash_cut($r, [qw/cid bid pid priority/]);
    $item->{priority} //= $priority;
    $log->out($item);
    push @resync, $item;
    flush();
}
flush('last');

$log->out("FINISH");
