#!/usr/bin/perl

use my_inc "../..";


=head1 DESCRIPTION

    Собираем данные из базы переводов и пишем их в po-файлы для последующего msgmerge с direct.pot
    В идеале запускается один раз

=cut

use strict;
use warnings;

use Yandex::Shell qw/yash_qx/;
use Settings;
use Yandex::DBTools;
use Yandex::I18n;
use Yandex::I18nTools;

use utf8;
use open ':std' => ':utf8';

my @langs = Yandex::I18n::get_other_langs();
my %translations = map {$_ => get_all_sql(PPCDICT, "select text_key, text_msg from i18n_keys join i18n_texts using (k_id) where text_key != '' AND lang = ?", $_)} @langs;

foreach my $lang (@langs) {
    open my $file, '>', $Settings::ROOT . '/locale/' . $Yandex::I18n::LOCALES{$lang} . '.po'
        or die 'could not open file ' . $!;
    print { $file } Yandex::I18nTools::get_po_header();
    foreach my $translation ( @{$translations{$lang}} ) {
        for (qw/text_key text_msg/) {
            $translation->{$_} =~ s/(?<!\\)"/\\"/g;
            $translation->{$_} =~ s/(?<!\\)\\'/'/g;
            $translation->{$_} =~ s/\r/\n/g;
            $translation->{$_} =~ s/\n/\\n/g;
            $translation->{$_} =~ s/\\u00AB/«/g;
            $translation->{$_} =~ s/\\u00BB/»/g;
        }
        if ($translation->{text_key} !~ /\\n$/) {
            $translation->{text_msg} =~ s/\\n$//;
        }
        if ($translation->{text_key} =~ /\\n$/ && $translation->{text_msg} !~ /\\n$/) {
            $translation->{text_msg} .= "\\n";
        }
        print { $file } qq[msgid "$translation->{text_key}"\n];
        print { $file } qq[msgstr "$translation->{text_msg}"\n\n];
    }
    close $file;
    yash_qx('msguniq', '--use-first', $Settings::ROOT.'/locale/'.$Yandex::I18n::LOCALES{$lang}.'.po', '-o', $Settings::ROOT.'/locale/tmp.po');
    yash_qx('mv', $Settings::ROOT.'/locale/tmp.po', $Settings::ROOT.'/locale/'.$Yandex::I18n::LOCALES{$lang}.'.po');
}
