#!/usr/bin/perl
use strict;
use warnings;

# minimun dependencies!

for my $inc (@ARGV) {
    $inc =~ s#/#::#gxms;
    $inc =~ s/\.pm$//xms;
    print "Loading $inc\n";
    eval "use $inc; 1" or die $@;
}

my %debs;
my %files;
for my $file (values %INC) {
    next if $file =~ m#/5.14/#;
    my $l = `dpkg -S $file`;
    my ($deb) = $l =~ /^(.*?):/;
    if ( !$deb || $deb eq "yandex-direct" ) {
        $file = "protected/$file"  if $file !~ m#^/#xms; 
        $file =~ s# ^ .* / (?= (?: protected|perl)/) ##xms;
        $files{$file} = 1;
    }
    else {
        $debs{$deb} = 1;
    }
}

if ( %files ) {
    print "\nFiles:\n" . join( qq{\n}, map {"- $_"} sort keys %files ) . "\n";
}

if ( %debs ) {
    print "\nDeb packages:\n" . join( qq{\n}, map {"- $_"} sort keys %debs ) . "\n";
}
