#!/usr/bin/perl

use my_inc "../..";

use Direct::Modern;

use Yandex::DBShards;
use Yandex::DBTools;
use File::Slurp qw/read_file/;
use List::MoreUtils qw/uniq/;

use Settings;
use ScriptHelper;

use RBACElementary qw/rbac_get_chief_reps_of_clients/;
use WalletLock;

my $FILE;
extract_script_params(
    'clientids=s' => \$FILE,
);

$log->out("START");

$log->out("read client ids from file '$FILE'");

die 'unknown file $FILE' unless -f $FILE;

my @client_ids = uniq split(/[^0-9]+/, read_file($FILE));

foreach_shard(ClientID => \@client_ids, chunk_size => 1000, sub {
    my ($shard, $client_ids_chunk) = @_;

    my $clientid2uid = rbac_get_chief_reps_of_clients($client_ids_chunk);
    my $clientid2lock_state = get_hash_sql(
        PPC(shard => $shard),
        ['select ClientID, state from wallet_campaigns_lock', where => [ ClientID => $client_ids_chunk]]
    );

    foreach my $clientid (@$client_ids_chunk) {
        if (defined $clientid2lock_state->{$clientid}) {
            $log->out(
                "ClientID: $clientid - Common wallet already locked. State: $clientid2lock_state->{$clientid}"
            );
            next;
        }

        unless ($clientid2uid->{$clientid}) {
            $log->out("ClientID: $clientid - Not found chief rep uid.");
            next;
        }

        if (my $error = WalletLock::lock_wallet($clientid2uid->{$clientid}, $clientid)) {
            $log->out("ClientID: $clientid - Error: $error");
        } else {
            $log->out("ClientID: $clientid - Common wallet success locked");
        }
    }
});

$log->out("FINISH");

