#!/usr/bin/perl

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;

use my_inc '../..';

use ScriptHelper;
use Settings;
use ShardingTools qw/foreach_shard_parallel_verbose/;

$log->out('START');

foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;
    while (my $ids = get_next_ids($shard)) {
        
        $log->out(sprintf "try to update %d mobile content ids", scalar @$ids);

        for my $ids_chunk (chunks $ids, 1000) {
            do_sql(PPC(shard => $shard), [
                "UPDATE mobile_content SET tries_count = 0",
                WHERE => {mobile_content_id => $ids_chunk},
               "AND tries_count > 0"
            ]);
            $log->out(sprintf "set tries count to 0 for ids %s", join ",", @$ids_chunk);
        }
    }
});

$log->out('FINISH');


sub get_next_ids {

    my $shard = shift;

    state $last_id = 0;

    my $ids = get_one_column_sql(PPC(shard => $shard),
        "SELECT mobile_content_id FROM mobile_content WHERE tries_count > 0 AND mobile_content_id > ? ORDER BY mobile_content_id LIMIT 10000", 
        $last_id);

    return undef unless @$ids;

    $last_id = $ids->[-1];
    $log->out(sprintf "looked mobile_content_id %d", $last_id);
    return $ids;
}
