#!/usr/bin/perl

use utf8;
use strict;
use warnings;

=head2 DESCRIPTION

    одноразовый скрипт для переноса api_users_units_consumption из MONITOR в PPC

=cut

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '../..';

use Settings;
use ScriptHelper;

$log->out("start");
my $rows = exec_sql(MONITOR, "SELECT uid, scheme, units, daily_units, date FROM api_users_units_consumption")->fetchall_arrayref();
foreach_shard uid => $rows, by => sub {$_->[0]}, sub {
    my ($shard, $chunk) = @_;
    do_mass_insert_sql(PPC(shard => $shard), 
                       "REPLACE INTO api_users_units_consumption (uid, scheme, units, daily_units, date) VALUES %s", 
                       $chunk, 
                       {sleep => 0, }
        );
};

$log->out("finish");
