#!/usr/bin/perl

=head1

    move_logmail_to_clickhouse.pl - разовый скрипт для переноса логов писем 
    из PPCLOG в ClickHouse

=cut

use Direct::Modern;

use my_inc '../..';


use POSIX qw/sprintf/;

use Yandex::DBTools;
use Yandex::Retry qw/relaxed_guard/;

use ScriptHelper;
use Settings;
use Tools qw/get_clickhouse_handler/;

my $SLEEP_COEF = 0.1;
my $DRYRUN = 0;
my $CHUNK_SIZE = 10_000;
my $FROM_DATE = '20000101';
my $TILL_DATE = '20191106';

$log->out('START');

extract_script_params(
    'dry'          => \$DRYRUN,
    'sleep_coef:f' => \$SLEEP_COEF,
    'chunk-size:i' => \$CHUNK_SIZE,
    'from-date=s'  => \$FROM_DATE,
    'till-date:s'  => \$TILL_DATE,
);

if ($FROM_DATE !~ /^\d{8}$/ || $TILL_DATE !~ /^\d{8}$/) {
    $log->die("Incorrect date format, expected YYYYMMDD");
}

my $CLH = get_clickhouse_handler('dscribe_writer');

move_log($FROM_DATE, $TILL_DATE);

$log->out('FINISH');

sub move_log {
    my ($from_date, $till_date) = @_;

    my @tables = sort grep {$_ ge "logmail_$from_date" && $_ le "logmail_$till_date"} 
    @{get_one_column_sql(PPCLOG_HEAVY, "show tables like 'logmail_%'")};

    for my $tbl (@tables) {
        $log->out("start process $tbl");
        get_dbh(PPCLOG_HEAVY)->{mysql_use_result} = 1;
        my $sth = exec_sql(PPCLOG_HEAVY,
            "SELECT date(logtime) as log_date,
                    logtime as log_time,
                    email, template_name, subject, uncompress(content) as content
               FROM $tbl
            ");
        my @cols = qw/log_date log_time email template_name subject content/;
        while(my $rows = $sth->fetchall_arrayref({}, $CHUNK_SIZE)) {
            my $guard = relaxed_guard(times => $SLEEP_COEF);

            my @data = ([@cols]);

            for my $row (@$rows) {
                push @data, [map {$row->{$_}} @cols];
            }

            if (!$DRYRUN) {
                $CLH->insert('mails', \@data, names => 1);
            }
            $log->out(sprintf('%s rows moved', scalar(@data) - 1));
        }
        $log->out("$tbl processed");
    }
}
