#!/usr/bin/perl


use Direct::Modern;

use my_inc '../..';

use Yandex::DBTools;

use ScriptHelper;
use Settings;
use Direct::Avatars;
use Yandex::HTTP qw/http_parallel_request/;



my $CHUNK_SIZE = 300;
local $Yandex::HTTP::DISABLE_STDERR_SPAM = 1;
local $Yandex::Avatars::MDS::LOG_PUT_REQUESTS = 1;
#local $Yandex::Avatars::MDS::DEFAULT_PUT_RPS = 10;

$log->out('START');

extract_script_params(
    'chunk_size=i' => \$CHUNK_SIZE,
    'hash=s' => \my @hashes,
    'hash-from=s' => \my $hash_from,
    'hash-to=s' => \my $hash_to,
);

my $avatars = Direct::Avatars->new(namespace => 'mcb');

    my $start_hash = $hash_from || '';
    CHUNK:
    while (my $chunk = _get_chunk($start_hash)) {
        my %image_info;
        my %get_request;
        for my $image_info (@$chunk) {
            my $image_hash = $image_info->{image_hash};
            $image_info{$image_hash} = $image_info;
            $start_hash = $image_hash;

            my $format = $image_info->{mime} eq 'SWF' ? 'swf' : 'orig';
            my $src_url = $image_info->{url} = $avatars->get_avatars_link($image_info, $format);
            $get_request{$image_hash} = { url => $src_url };
        }

        $log->out(sprintf 'downloading set of %d images', scalar @$chunk);
        my $get_result = http_parallel_request(GET => \%get_request);

        my %put_request;
        GET_RESULT:
        for my $image_info (@$chunk) {
            my $image_hash = $image_info->{image_hash};
            my $response = $get_result->{$image_hash};
            if (!$response->{is_success}) {
                $log->out("ERROR: failed to download $image_info->{url}");
                next GET_RESULT;
            }

            my $image_data = $response->{content};

            my $req = $put_request{$image_hash} = {data => $image_data};
            $req->{file_field_name} = 'swf'  if $image_info->{mime} eq 'SWF';
        }

        $log->out(sprintf 'uploading set of %d images', scalar keys %put_request);
        my $multi_result = $avatars->put_multi(\%put_request);

        my %update_data;

        RESULT:
        for my $image_hash (sort keys %$multi_result) {
            my $put_result = $multi_result->{$image_hash};
            my $image_info = $image_info{$image_hash};
            my $src_url = $image_info->{url};
            if (!$put_result->{'group-id'}) {
                my $error_msg = $put_result->{description} || "$put_result->{http_code} $put_result->{http_message}";
                $log->out("ERROR: failed to upload image $src_url: $error_msg");
                next RESULT;
            }

            $log->out("image $image_hash moved to mds_group_id=$put_result->{'group-id'}");

            $update_data{$image_hash} = {
                mds_group_id => $put_result->{"group-id"},
                avatars_host => $put_result->{avatars_host},
            };
        }

        next if !%update_data;

        $log->out("resending associated banners");

        my @hashes = keys %update_data;
        do_in_transaction {
            do_mass_update_sql(PPCDICT, media_files => md5 => \%update_data);
            # note: fullscan!
            do_update_table(PPC(shard => 'all'), media_banners => {statusBsSynced => 'No'},
                where => {_OR => {md5_flash => \@hashes, md5_picture => \@hashes}}
            );
        };

    }

$log->out('FINISH');



sub _get_chunk {
    my ($shart_hash) = @_;

    my $chunk = get_all_sql(PPCDICT, [
            'SELECT mf.*, md5 as image_hash
            FROM media_files mf',
            WHERE => {
                md5__gt => $shart_hash,
                mds_group_id__is_null => 1,
                (@hashes ? (md5 => @hashes) : ()),
                ($hash_to ? (md5__le => $hash_to) : ()),
            },
            'ORDER BY md5 ASC',
            LIMIT => $CHUNK_SIZE,
        ]);
    return if !@$chunk;
    return $chunk;
}


